/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterGeneric;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMemory;

public class DefaultIndexTable
extends AbstractIndexTable
implements ITableWriterGeneric {
    protected IMemory<Tuple> rows = CollectionsFactory.createMultiset();
    protected Map<TupleMask, MaskedTupleMemory<?>> indexMemories = CollectionsFactory.createMap();
    private boolean unique;

    public DefaultIndexTable(IInputKey inputKey, ITableContext tableContext, boolean unique) {
        super(inputKey, tableContext);
        this.unique = unique;
    }

    @Override
    public void write(Direction direction, Tuple row) {
        if (direction == Direction.INSERT) {
            boolean changed = this.rows.addOne(row);
            if (this.unique && !changed) {
                String msg = String.format("Error: trying to add duplicate row %s to the unique table %s. This indicates some errors in underlying model representation.", row, this.getInputKey().getPrettyPrintableName());
                this.logError(msg);
            }
            if (changed) {
                for (MaskedTupleMemory<?> indexMemory : this.indexMemories.values()) {
                    indexMemory.add(row);
                }
                if (this.emitNotifications) {
                    this.deliverChangeNotifications(row, true);
                }
            }
        } else {
            boolean changed = this.rows.removeOne(row);
            if (this.unique && !changed) {
                String msg = String.format("Error: trying to remove duplicate value %s from the unique table %s. This indicates some errors in underlying model representation.", row, this.getInputKey().getPrettyPrintableName());
                this.logError(msg);
            }
            if (changed) {
                for (MaskedTupleMemory<?> indexMemory : this.indexMemories.values()) {
                    indexMemory.remove(row);
                }
                if (this.emitNotifications) {
                    this.deliverChangeNotifications(row, false);
                }
            }
        }
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        return this.rows.distinctValues().contains(seed);
    }

    private MaskedTupleMemory<?> getIndexMemory(TupleMask seedMask) {
        return this.indexMemories.computeIfAbsent(seedMask, mask -> {
            MaskedTupleMemory memory = MaskedTupleMemory.create(seedMask, CollectionsFactory.MemoryType.SETS, this);
            for (Tuple tuple : this.rows.distinctValues()) {
                memory.add(tuple);
            }
            return memory;
        });
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        switch (seedMask.getSize()) {
            case 0: {
                return this.rows.size();
            }
        }
        return this.getIndexMemory(seedMask).getOrEmpty(seed).size();
    }

    @Override
    public Optional<Long> estimateProjectionSize(TupleMask groupMask, Accuracy requiredAccuracy) {
        if (groupMask.getSize() == 0) {
            return this.rows.size() == 0 ? Optional.of(0L) : Optional.of(1L);
        }
        if (groupMask.getSize() == this.emptyTuple.getSize()) {
            return Optional.of(Long.valueOf(this.rows.size()));
        }
        return Optional.of(Long.valueOf(this.getIndexMemory(groupMask).getKeysetSize()));
    }

    @Override
    public Iterable<Tuple> enumerateTuples(TupleMask seedMask, ITuple seed) {
        return this.getIndexMemory(seedMask).getOrEmpty(seed);
    }

    @Override
    public Stream<? extends Tuple> streamTuples(TupleMask seedMask, ITuple seed) {
        return this.getIndexMemory(seedMask).getOrEmpty(seed).stream();
    }

    @Override
    public Stream<? extends Object> streamValues(TupleMask seedMask, ITuple seed) {
        int queriedColumn = seedMask.getFirstOmittedIndex().getAsInt();
        return this.getIndexMemory(seedMask).getOrEmpty(seed).stream().map(row2 -> row2.get(queriedColumn));
    }
}

