/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.association;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.association.ConstructorAssociation;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerMethodBinding;

public final class ConstructorChildAssociation
extends ConstructorAssociation {
    @Override
    public ClassInstanceCreation getCreation() {
        return this.getConstructorCreationSupport().getCreation();
    }

    private ConstructorCreationSupport getConstructorCreationSupport() {
        return (ConstructorCreationSupport)this.m_javaInfo.getParentJava().getCreationSupport();
    }

    @Override
    public boolean canDelete() {
        if (this.m_javaInfo.getParentJava().isDeleting()) {
            return true;
        }
        ConstructorCreationSupport creationSupport = this.getConstructorCreationSupport();
        DesignerMethodBinding newBinding = this.m_editor.getBindingContext().get(creationSupport.getBinding());
        List<Expression> arguments = DomGenerics.arguments(this.getCreation());
        int i = arguments.size() - 1;
        while (i >= 0) {
            Expression argument = arguments.get(i);
            if (this.m_javaInfo.isRepresentedBy((ASTNode)argument)) {
                newBinding.removeParameterType(i);
            }
            --i;
        }
        return this.m_javaInfo.getParentJava().getDescription().getConstructor(newBinding) != null;
    }

    @Override
    public boolean remove() throws Exception {
        if (!this.m_javaInfo.getParentJava().isDeleting()) {
            ConstructorCreationSupport creationSupport = this.getConstructorCreationSupport();
            ClassInstanceCreation creation = creationSupport.getCreation();
            List<Expression> arguments = DomGenerics.arguments(creation);
            int i = arguments.size() - 1;
            while (i >= 0) {
                Expression argument = arguments.get(i);
                if (this.m_javaInfo.isRepresentedBy((ASTNode)argument)) {
                    this.m_javaInfo.getEditor().removeCreationArgument(creation, i);
                }
                --i;
            }
            this.m_javaInfo.getParentJava().setCreationSupport(new ConstructorCreationSupport(creation));
        }
        return super.remove();
    }
}

