/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gefTree.policy.dblclick;

import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.wb.core.gefTree.part.JavaEditPart;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.policy.OpenListenerEditPolicy;
import org.eclipse.wb.internal.core.gefTree.policy.dblclick.OpenEditorLayoutEditPolicy;
import org.eclipse.wb.internal.core.gefTree.policy.dblclick.RenameJavaInfoLayoutEditPolicy;
import org.eclipse.wb.internal.core.preferences.IPreferenceConstants;

public abstract class DoubleClickLayoutEditPolicy
extends org.eclipse.wb.gef.core.policies.EditPolicy
implements IPreferenceConstants {
    protected final JavaInfo m_javaInfo;

    public DoubleClickLayoutEditPolicy(JavaInfo javaInfo) {
        this.m_javaInfo = javaInfo;
    }

    public static void install(JavaEditPart editPart) {
        int mode = DesignerPlugin.getPreferences().getInt("editor.dblClickOnWidgetInTreeAction");
        JavaInfo javaInfo = editPart.getJavaInfo();
        org.eclipse.wb.gef.core.policies.EditPolicy editPolicy = null;
        switch (mode) {
            case 0: {
                editPolicy = new OpenEditorLayoutEditPolicy(javaInfo);
                break;
            }
            case 1: {
                editPolicy = new OpenListenerEditPolicy(javaInfo);
                break;
            }
            case 2: {
                editPolicy = new RenameJavaInfoLayoutEditPolicy(javaInfo);
            }
        }
        editPart.installEditPolicy(DoubleClickLayoutEditPolicy.class, (EditPolicy)editPolicy);
    }

    public void performRequest(Request request) {
        if ("open".equals(request.getType())) {
            this.performDoubleClick();
        }
        super.performRequest(request);
    }

    protected abstract void performDoubleClick();
}

