/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.util.List;
import java.util.Map;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

public abstract class AbstractListPropertyEditor
extends AbstractComboPropertyEditor
implements IConfigurablePropertyObject,
IValueSourcePropertyEditor,
IClipboardSourceProvider {
    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            int index = this.getValueIndex(value);
            if (index >= 0) {
                return this.getTitle(index);
            }
            if (value instanceof String) {
                return (String)value;
            }
        }
        return null;
    }

    public String getValueSource(Object value) throws Exception {
        int index;
        if (value != Property.UNKNOWN_VALUE && (index = this.getValueIndex(value)) >= 0) {
            return this.getExpression(index);
        }
        return null;
    }

    @Override
    public String getClipboardSource(GenericProperty property) throws Exception {
        Object value = property.getValue();
        return this.getValueSource(value);
    }

    protected void addItems(Property property, CCombo3 combo) throws Exception {
        int i = 0;
        while (i < this.getCount()) {
            combo.add(this.getTitle(i));
            ++i;
        }
    }

    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    /*
     * WARNING - void declaration
     */
    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        Property property2 = property;
        if (property2 instanceof GenericProperty) {
            void genericProperty;
            GenericProperty genericProperty2 = (GenericProperty)property2;
            GenericProperty cfr_ignored_0 = (GenericProperty)property2;
            String expression = this.getExpression(index);
            Object evaluatedExpression = AbstractListPropertyEditor.evaluateExpression((GenericProperty)genericProperty, expression);
            genericProperty.setExpression(expression, evaluatedExpression);
        } else {
            this.toPropertyEx_simpleProperty(property, combo, index);
        }
    }

    private static Object evaluateExpression(final GenericProperty genericProperty, final String expression) {
        return ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Object>(){

            public Object runObject() throws Exception {
                JavaInfo javaInfo = genericProperty.getJavaInfo();
                ClassLoader classLoader = JavaInfoUtils.getClassLoader(javaInfo);
                return ScriptUtils.evaluate((ClassLoader)classLoader, (String)expression);
            }
        }, (Object)Property.UNKNOWN_VALUE);
    }

    protected void toPropertyEx_simpleProperty(Property property, CCombo3 combo, int index) throws Exception {
    }

    protected abstract int getCount();

    protected abstract int getValueIndex(Object var1);

    protected abstract String getTitle(int var1);

    protected abstract String getExpression(int var1) throws Exception;

    protected static String[] getParameterAsArray(Map<String, Object> parameters, String name) {
        return AbstractListPropertyEditor.getParameterAsArray(parameters, name, false);
    }

    protected static String[] getParameterAsArray(Map<String, Object> parameters, String name, boolean noAssert) {
        String[] values = null;
        if (parameters.containsKey(name)) {
            List list = (List)parameters.get(name);
            values = list.toArray(new String[list.size()]);
        } else if (noAssert) {
            values = null;
        } else {
            Assert.fail((String)String.format("No parameter %s in %s.", name, parameters));
        }
        return values;
    }
}

