/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.core;

import java.io.Reader;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

public class JavadocContentAccess {
    private JavadocContentAccess() {
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws Exception {
        IMethod method;
        IMethod superMethod;
        IBuffer buffer;
        IBuffer iBuffer = buffer = member.isBinary() ? member.getClassFile().getBuffer() : member.getCompilationUnit().getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = member.getSourceRange();
        int start = range.getOffset();
        int length = range.getLength();
        if (length > 0 && buffer.getChar(start) == '/') {
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(buffer.getCharacters());
            scanner.resetTo(start, start + length - 1);
            int docOffset = -1;
            int docEnd = -1;
            int terminal = scanner.getNextToken();
            while (TokenScanner.isComment((int)terminal)) {
                if (terminal == 1003) {
                    docOffset = scanner.getCurrentTokenStartPosition();
                    docEnd = scanner.getCurrentTokenEndPosition() + 1;
                }
                terminal = scanner.getNextToken();
            }
            if (docOffset != -1) {
                return new JavaDocCommentReader(buffer, docOffset, docEnd);
            }
        }
        if (allowInherited && member.getElementType() == 9 && (superMethod = CodeUtils.findSuperMethod(method = (IMethod)member)) != null) {
            return JavadocContentAccess.getContentReader((IMember)superMethod, allowInherited);
        }
        return null;
    }
}

