/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.test;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.core.controls.CSpinner;
import org.eclipse.wb.core.controls.CSpinnerDeferredNotifier;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public class CSpinnerTest {
    protected Shell shell;

    public static void main(String[] args) {
        try {
            CSpinnerTest window = new CSpinnerTest();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell();
        this.shell.setSize(500, 375);
        this.shell.setLocation(700, 400);
        this.shell.setText("SWT Application");
        GridLayoutFactory.create((Composite)this.shell);
        CSpinner spinner = new CSpinner((Composite)this.shell, 0);
        GridDataFactory.create((Control)spinner).hintHC(10);
        spinner.setSelection(-50);
        spinner.setMinimum(-15);
        spinner.setMaximum(100);
        final Label valueLabel = new Label((Composite)this.shell, 0);
        spinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CSpinnerTest.this.updateValueLabel(event, valueLabel);
            }
        });
        valueLabel = new Label((Composite)this.shell, 0);
        new CSpinnerDeferredNotifier(spinner, 500, new Listener(){

            public void handleEvent(Event event) {
                CSpinnerTest.this.updateValueLabel(event, valueLabel);
            }
        });
        Group group = new Group((Composite)this.shell, 0);
        GridLayoutFactory.create((Composite)group).columns(2);
        new Label((Composite)group, 0).setText("Standard Spinner:");
        Object spinner2 = new Spinner((Composite)group, 2048);
        GridDataFactory.create((Control)spinner2).alignVM().hintHC(15);
        new Label((Composite)group, 0).setText("Standard Spinner, digits 2:");
        spinner2 = new Spinner((Composite)group, 2048);
        GridDataFactory.create((Control)spinner2).alignVM().hintHC(15);
        spinner2.setDigits(2);
        new Label((Composite)group, 0).setText("CSpinner [-15,30]:");
        spinner2 = new CSpinner((Composite)group, 2048);
        GridDataFactory.create((Control)spinner2).alignVM().hintHC(15);
        spinner2.setSelection(5);
        spinner2.setMinimum(-15);
        spinner2.setMaximum(30);
        new Label((Composite)group, 0).setText("CSpinner [-10.00, +20.00]:");
        spinner2 = new CSpinner((Composite)group, 2048);
        GridDataFactory.create((Control)spinner2).alignVM().hintHC(15);
        spinner2.setSelection(5);
        spinner2.setMinimum(-1000);
        spinner2.setMaximum(2000);
        spinner2.setDigits(2);
        new Label((Composite)group, 0).setText("Text:");
        Text text = new Text((Composite)group, 2048);
        GridDataFactory.create((Control)text).alignVM().hintHC(15);
        new Label((Composite)group, 0).setText("CSpinner [-inf,+inf]:");
        spinner2 = new CSpinner((Composite)group, 2048);
        GridDataFactory.create((Control)spinner2).alignVM().hintHC(15);
        new Label((Composite)group, 0).setText("Button SWT.ARROW:");
        Button button = new Button((Composite)group, 4);
        GridDataFactory.create((Control)button).alignVM();
    }

    private void updateValueLabel(Event event, Label valueLabel) {
        valueLabel.setText("value: " + event.detail);
        valueLabel.setForeground(event.doit ? ColorConstants.black : ColorConstants.red);
        this.shell.layout();
    }
}

