/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.FigureVisitor;
import org.eclipse.wb.internal.draw2d.ICustomTooltipProvider;

public class Figure
extends org.eclipse.draw2d.Figure {
    private Figure m_parent;
    private List<Figure> m_children;
    private String m_toolTipText;
    private ICustomTooltipProvider m_customTooltipProvider;

    public <T> Iterator<T> getListeners(Class<T> listenerClass) {
        return super.getListeners(listenerClass);
    }

    public void addNotify() {
        for (Figure childFigure : this.getChildren()) {
            childFigure.addNotify();
        }
    }

    public void removeNotify() {
        for (Figure childFigure : this.getChildren()) {
            childFigure.removeNotify();
        }
    }

    public final void accept(FigureVisitor visitor, boolean forward) {
        if (visitor.visit(this)) {
            List<Figure> children = this.getChildren();
            int size = children.size();
            if (forward) {
                int i = 0;
                while (i < size) {
                    Figure childFigure = children.get(i);
                    childFigure.accept(visitor, forward);
                    ++i;
                }
            } else {
                int i = size - 1;
                while (i >= 0) {
                    Figure childFigure = children.get(i);
                    childFigure.accept(visitor, forward);
                    --i;
                }
            }
            visitor.endVisit(this);
        }
    }

    public void add(Figure childFigure) {
        this.add(childFigure, null, -1);
    }

    public void add(Figure childFigure, int index) {
        this.add(childFigure, null, index);
    }

    public void add(Figure childFigure, Rectangle bounds) {
        this.add(childFigure, bounds, -1);
    }

    public void add(Figure childFigure, Rectangle bounds, int index) {
        if (childFigure.getParent() != null) {
            throw new IllegalArgumentException("Figure.add(...) Figure already added to parent");
        }
        Figure f = this;
        while (f != null) {
            if (childFigure == f) {
                throw new IllegalArgumentException("IWAG0002E Figure.add(...) Cycle created in figure heirarchy");
            }
            f = f.getParent();
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList<Figure>();
        }
        if (index < -1 || index > this.m_children.size()) {
            throw new IndexOutOfBoundsException("IWAG0001E Figure.add(...) invalid index");
        }
        if (index == -1) {
            this.m_children.add(childFigure);
        } else {
            this.m_children.add(index, childFigure);
        }
        childFigure.setParent(this);
        childFigure.addNotify();
        if (bounds != null) {
            childFigure.setBounds(bounds);
        }
        this.resetState(childFigure);
    }

    public List<Figure> getChildren() {
        return this.m_children == null ? Collections.emptyList() : this.m_children;
    }

    public void remove(Figure childFigure) {
        if (this.m_children == null || this.m_children.isEmpty()) {
            throw new IllegalArgumentException("This parent is empty");
        }
        if (childFigure.getParent() != this || !this.m_children.contains((Object)childFigure)) {
            throw new IllegalArgumentException("IWAG0003E Figure is not a child of this parent");
        }
        childFigure.removeNotify();
        this.m_children.remove((Object)childFigure);
        childFigure.setParent(null);
        this.resetState(childFigure);
    }

    public void removeAll() {
        for (Figure childFigure : this.getChildren()) {
            childFigure.removeNotify();
            childFigure.setParent(null);
        }
        if (this.m_children != null && !this.m_children.isEmpty() && this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
        this.m_children = null;
    }

    public FigureCanvas getFigureCanvas() {
        return this.m_parent.getFigureCanvas();
    }

    public Figure getParent() {
        return this.m_parent;
    }

    public void setParent(Figure parent) {
        Figure oldParent = this.m_parent;
        this.m_parent = parent;
        this.firePropertyChange("parent", (Object)oldParent, (Object)parent);
    }

    protected final void resetState(Figure childFigure) {
        if (this.isVisible() && childFigure.isVisible()) {
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            Rectangle childBounds = childFigure.getBounds();
            this.revalidate();
            this.repaint(bounds.x + insets.left + childBounds.x, bounds.y + insets.top + childBounds.y, childBounds.width, childBounds.height);
        }
    }

    public final void paint(Graphics graphics) {
        if (this.getBackgroundColor() != null) {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        if (this.getForegroundColor() != null) {
            graphics.setForegroundColor(this.getForegroundColor());
        }
        if (this.getFont() != null) {
            graphics.setFont(this.getFont());
        }
        graphics.pushState();
        try {
            this.paintFigure(graphics);
            this.paintChildren(graphics);
            this.paintBorder(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            Rectangle bounds = this.getBounds();
            graphics.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        this.paintClientArea(graphics);
        graphics.restoreState();
    }

    protected void paintChildren(Graphics graphics) {
        List<Figure> children = this.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        graphics.pushState();
        for (Figure childFigure : children) {
            if (!childFigure.isVisible() || !childFigure.intersects(graphics.getClip(new Rectangle()))) continue;
            Rectangle childBounds = childFigure.getBounds();
            graphics.clipRect(childBounds);
            graphics.translate(childBounds.x, childBounds.y);
            childFigure.paint(graphics);
            graphics.restoreState();
        }
        graphics.popState();
        graphics.restoreState();
    }

    protected void paintClientArea(Graphics graphics) {
    }

    public String getToolTipText() {
        return this.m_toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.m_toolTipText = toolTipText;
    }

    public ICustomTooltipProvider getCustomTooltipProvider() {
        return this.m_customTooltipProvider;
    }

    public void setCustomTooltipProvider(ICustomTooltipProvider provider) {
        this.m_customTooltipProvider = provider;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

