/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.errors.report2.FileReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.Messages;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferencesFileReportEntry
extends FileReportEntry {
    private static final String EXPORT_ERROR_MESSAGE = Messages.PreferencesFileReportEntry_errorMessage;
    private static final String PREFERENCES_PREFIX = "org.eclipse.wb";

    public PreferencesFileReportEntry() {
        super("preferences.epf");
    }

    @Override
    protected InputStream getContents() {
        Status exportStatus = null;
        try {
            IPreferencesService service = Platform.getPreferencesService();
            IEclipsePreferences node = (IEclipsePreferences)service.getRootNode().node("instance");
            final ArrayList excludesList = new ArrayList();
            node.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences childNode) throws BackingStoreException {
                    if (childNode.name().equals("instance")) {
                        return true;
                    }
                    if (!StringUtils.contains((CharSequence)childNode.absolutePath(), (CharSequence)PreferencesFileReportEntry.PREFERENCES_PREFIX)) {
                        excludesList.add(childNode.name());
                    }
                    return true;
                }
            });
            ByteArrayOutputStream exportStream = new ByteArrayOutputStream();
            exportStatus = service.exportPreferences(node, (OutputStream)exportStream, excludesList.toArray(new String[excludesList.size()]));
            if (exportStatus.getCode() != 0) {
                throw new RuntimeException(EXPORT_ERROR_MESSAGE);
            }
            return new ByteArrayInputStream(exportStream.toByteArray());
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
            ErrorDialog.openError((Shell)DesignerPlugin.getShell(), (String)Messages.PreferencesFileReportEntry_errorTitle, (String)EXPORT_ERROR_MESSAGE, (IStatus)(exportStatus == null ? new Status(4, "org.eclipse.wb.core", 0, null, e) : exportStatus));
            return null;
        }
    }
}

