/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class TableLayoutComposite
extends Composite {
    private static int COLUMN_TRIM = "carbon".equals(SWT.getPlatform()) ? 24 : 3;
    private final List<ColumnLayoutData> columns = new ArrayList<ColumnLayoutData>();

    public TableLayoutComposite(Composite parent, int style) {
        super(parent, style);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = TableLayoutComposite.this.getClientArea();
                Table table = (Table)TableLayoutComposite.this.getChildren()[0];
                Point preferredSize = TableLayoutComposite.this.computeTableSize(table);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                TableLayoutComposite.this.layoutTable(table, width, area, table.getSize().x < area.width);
            }
        });
    }

    public void addColumnData(ColumnLayoutData data) {
        this.columns.add(data);
    }

    /*
     * WARNING - void declaration
     */
    private Point computeTableSize(Table table) {
        Point result = table.computeSize(-1, -1);
        int width = 0;
        int size = this.columns.size();
        int i = 0;
        while (i < size) {
            ColumnLayoutData layoutData = this.columns.get(i);
            ColumnLayoutData columnLayoutData = layoutData;
            if (columnLayoutData instanceof ColumnPixelData) {
                void col;
                ColumnPixelData cfr_ignored_0 = (ColumnPixelData)columnLayoutData;
                ColumnPixelData cfr_ignored_1 = (ColumnPixelData)columnLayoutData;
                width += col.width;
                if (col.addTrim) {
                    width += COLUMN_TRIM;
                }
            } else {
                ColumnLayoutData columnLayoutData2 = layoutData;
                if (columnLayoutData2 instanceof ColumnWeightData) {
                    void col;
                    ColumnWeightData cfr_ignored_2 = (ColumnWeightData)columnLayoutData2;
                    ColumnWeightData cfr_ignored_3 = (ColumnWeightData)columnLayoutData2;
                    width += col.minimumWidth;
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown column layout data");
                }
            }
            ++i;
        }
        if (width > result.x) {
            result.x = width;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void layoutTable(Table table, int width, Rectangle area, boolean increase) {
        if (width <= 1) {
            return;
        }
        TableColumn[] tableColumns = table.getColumns();
        int size = Math.min(this.columns.size(), tableColumns.length);
        int[] widths = new int[size];
        int fixedWidth = 0;
        int numberOfWeightColumns = 0;
        int totalWeight = 0;
        int i = 0;
        while (i < size) {
            ColumnLayoutData col = this.columns.get(i);
            ColumnLayoutData columnLayoutData = col;
            if (columnLayoutData instanceof ColumnPixelData) {
                void cpd;
                ColumnPixelData cfr_ignored_0 = (ColumnPixelData)columnLayoutData;
                ColumnPixelData cfr_ignored_1 = (ColumnPixelData)columnLayoutData;
                int pixels = cpd.width;
                if (cpd.addTrim) {
                    pixels += COLUMN_TRIM;
                }
                widths[i] = pixels;
                fixedWidth += pixels;
            } else {
                ColumnLayoutData columnLayoutData2 = col;
                if (columnLayoutData2 instanceof ColumnWeightData) {
                    void cw;
                    ColumnWeightData cfr_ignored_2 = (ColumnWeightData)columnLayoutData2;
                    ColumnWeightData cfr_ignored_3 = (ColumnWeightData)columnLayoutData2;
                    ++numberOfWeightColumns;
                    int weight = cw.weight;
                    totalWeight += weight;
                } else {
                    Assert.isTrue((boolean)false, (String)"Unknown column layout data");
                }
            }
            ++i;
        }
        if (numberOfWeightColumns > 0) {
            int rest = width - fixedWidth;
            int totalDistributed = 0;
            int i2 = 0;
            while (i2 < size) {
                ColumnLayoutData col = this.columns.get(i2);
                ColumnLayoutData columnLayoutData = col;
                if (columnLayoutData instanceof ColumnWeightData) {
                    int pixels;
                    void cw;
                    ColumnWeightData cfr_ignored_4 = (ColumnWeightData)columnLayoutData;
                    ColumnWeightData cfr_ignored_5 = (ColumnWeightData)columnLayoutData;
                    int weight = cw.weight;
                    int n = pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                    if (pixels < cw.minimumWidth) {
                        pixels = cw.minimumWidth;
                    }
                    totalDistributed += pixels;
                    widths[i2] = pixels;
                }
                ++i2;
            }
            int diff = rest - totalDistributed;
            int i3 = 0;
            while (diff > 0) {
                ColumnLayoutData col;
                if (i3 == size) {
                    i3 = 0;
                }
                if ((col = this.columns.get(i3)) instanceof ColumnWeightData) {
                    int n = i3;
                    widths[n] = widths[n] + 1;
                    --diff;
                }
                ++i3;
            }
        }
        if (increase) {
            table.setSize(area.width, area.height);
        }
        i = 0;
        while (i < size) {
            tableColumns[i].setWidth(widths[i]);
            ++i;
        }
        if (!increase) {
            table.setSize(area.width, area.height);
        }
    }
}

