/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.wst.common.internal.emf.resource.MappedXMIHelper;

public class CompatibilityXMISaveImpl
extends XMISaveImpl {
    public CompatibilityXMISaveImpl(XMLHelper helper) {
        super(helper);
    }

    public CompatibilityXMISaveImpl(Map options, XMLHelper helper, String encoding) {
        super(options, helper, encoding);
    }

    protected void init(XMLResource resource, Map options) {
        super.init(resource, options);
        this.xmiType = true;
    }

    public void addNamespaceDeclarations() {
        EPackage ePackage;
        int i;
        this.doc.addAttribute("xmi:version", "2.0");
        this.doc.addAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        EPackage[] packages = this.helper.packages();
        StringBuffer xsiSchemaLocation = null;
        if (this.declareSchemaLocation) {
            i = 0;
            while (i < packages.length) {
                EPackage rootEPackage;
                Resource resource;
                ePackage = packages[i];
                EObject root = EcoreUtil.getRootContainer((EObject)ePackage);
                if (root instanceof EPackage && (resource = (rootEPackage = (EPackage)root).eResource()) != null) {
                    URI uri = resource.getURI();
                    String rootNsURI = rootEPackage.getNsURI();
                    if (uri == null ? rootNsURI != null : !uri.toString().equals(rootNsURI)) {
                        this.declareXSI = true;
                        if (xsiSchemaLocation == null) {
                            xsiSchemaLocation = new StringBuffer();
                        } else {
                            xsiSchemaLocation.append(' ');
                        }
                        xsiSchemaLocation.append(rootNsURI);
                        xsiSchemaLocation.append(' ');
                        xsiSchemaLocation.append(this.helper.getHREF((EObject)rootEPackage));
                    }
                }
                ++i;
            }
        }
        if (this.declareXSI) {
            this.doc.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        i = 0;
        while (i < packages.length) {
            ePackage = packages[i];
            String[] nsInfo = ((MappedXMIHelper)this.helper).getNSInfo(ePackage);
            this.doc.addAttributeNS("xmlns", nsInfo[0], nsInfo[1]);
            ++i;
        }
        if (xsiSchemaLocation != null) {
            this.doc.addAttribute("xsi:schemaLocation", xsiSchemaLocation.toString());
        }
    }

    protected void saveHref(EObject remote, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        String href = this.helper.getHREF(remote);
        if (href != null) {
            this.doc.startElement(name);
            EClass eClass = remote.eClass();
            EClass expectedType = (EClass)f.getEType();
            if (eClass != expectedType) {
                this.saveTypeAttribute(eClass);
            }
            this.doc.addAttribute("href", href);
            this.doc.endEmptyElement();
        }
    }
}

