/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.snippets.core.ISnippetProvider;
import org.eclipse.wst.common.snippets.internal.editors.ISnippetEditor;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItemFactory;

public abstract class AbstractSnippetProvider
implements ISnippetProvider {
    protected IEditorPart fEditorPart;

    @Override
    public void setEditor(IEditorPart editor) {
        this.fEditorPart = editor;
    }

    @Override
    public SnippetPaletteItem createSnippet(PaletteEntry drawer) throws CoreException {
        SnippetPaletteItem snippet = this.createSnippetMetadata(drawer);
        return snippet;
    }

    protected SnippetPaletteItem createSnippetMetadata(PaletteEntry drawer) throws CoreException {
        SnippetPaletteItem item = (SnippetPaletteItem)new SnippetPaletteItemFactory().createNewEntry(this.fEditorPart.getSite().getShell(), drawer);
        item.setProvider(this);
        IStatus status = this.saveAdditionalContent(item.getStorageLocation());
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        return item;
    }

    @Override
    public ISnippetEditor getSnippetEditor() {
        return null;
    }
}

