/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSDocumentImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelImpl;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

class CSSPrimitiveValueImpl
extends CSSRegionContainer
implements ICSSPrimitiveValue {
    protected short fPrimitiveType = 0;
    private float fFloatValue = 0.0f;
    private String fStringValue = null;

    CSSPrimitiveValueImpl(CSSPrimitiveValueImpl that) {
        super(that);
        this.fPrimitiveType = that.fPrimitiveType;
        this.fFloatValue = that.fFloatValue;
        this.fStringValue = that.fStringValue;
    }

    CSSPrimitiveValueImpl(short primitiveType) {
        this.fPrimitiveType = primitiveType;
    }

    @Override
    public ICSSNode cloneNode(boolean deep) {
        CSSPrimitiveValueImpl cloned = new CSSPrimitiveValueImpl(this);
        return cloned;
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "");
    }

    @Override
    public String getCSSValueText() {
        return this.getCssText();
    }

    @Override
    public short getCssValueType() {
        if (this.getPrimitiveType() == 33) {
            return 0;
        }
        return 1;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        switch (this.fPrimitiveType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: {
                return this.fFloatValue;
            }
        }
        throw new DOMException(15, "");
    }

    @Override
    public short getNodeType() {
        return 11;
    }

    @Override
    public short getPrimitiveType() {
        return this.fPrimitiveType;
    }

    @Override
    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "");
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        throw new DOMException(15, "");
    }

    @Override
    public String getStringValue() throws DOMException {
        switch (this.fPrimitiveType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return this.fStringValue;
            }
        }
        throw new DOMException(15, "");
    }

    protected void notifyValueChanged(String oldValue) {
        CSSDocumentImpl doc = this.getContainerDocument();
        if (doc == null) {
            return;
        }
        CSSModelImpl model = (CSSModelImpl)doc.getModel();
        if (model == null) {
            return;
        }
        model.valueChanged(this, oldValue);
        this.notify(1, new Short(this.fPrimitiveType), null, null, this.getStartOffset());
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        switch (unitType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: {
                String oldValue = this.getCSSValueText();
                this.fPrimitiveType = unitType;
                this.fFloatValue = floatValue;
                this.notifyValueChanged(oldValue);
                break;
            }
            default: {
                throw new DOMException(15, "");
            }
        }
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        switch (stringType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                String oldValue = this.getCSSValueText();
                this.fPrimitiveType = stringType;
                this.fStringValue = stringValue;
                this.notifyValueChanged(oldValue);
                break;
            }
            default: {
                throw new DOMException(15, "");
            }
        }
    }

    @Override
    public void setValue(float floatValue) throws DOMException {
        this.setFloatValue(this.getPrimitiveType(), floatValue);
    }

    @Override
    public void setValue(String stringValue) throws DOMException {
        this.setStringValue(this.getPrimitiveType(), stringValue);
    }
}

