/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AbstractCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.stylesheets.MediaList;

public class MediaRuleFormatter
extends AbstractCSSSourceFormatter {
    public static final String MEDIA = "@media";
    private static MediaRuleFormatter instance;

    MediaRuleFormatter() {
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, String toAppend, StringBuffer source, IRegion exceptFor) {
        int end;
        ICSSNode prev = child != null ? child.getPreviousSibling() : node.getLastChild();
        int start = prev != null ? ((IndexedRegion)prev).getEndOffset() : 0;
        int n = end = child != null ? ((IndexedRegion)child).getStartOffset() : 0;
        if (start > 0 && start < end) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = null;
            if (exceptFor == null) {
                regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            } else {
                String pickupType = null;
                if (prev != null && prev.getNodeType() == 12 || prev == null && (child == null || child.getNodeType() != 12)) {
                    pickupType = "LBRACE";
                }
                regions = this.getRegions(structuredDocument, new FormatRegion(start, end - start), exceptFor, pickupType);
            }
            if (child != null && child.getNodeType() == 12 && ((MediaList)((Object)child)).getLength() > 0) {
                int i = 0;
                while (i < regions.length) {
                    this.appendSpaceBefore(node, regions[i], source);
                    source.append(this.decoratedRegion(regions[i], 0, stgy));
                    ++i;
                }
                this.appendSpaceBefore(node, toAppend, source);
            } else if (child != null && (child.getPreviousSibling() == null || child.getPreviousSibling().getNodeType() == 12)) {
                int i = 0;
                while (i < regions.length) {
                    this.appendSpaceBefore(node, regions[i], source);
                    source.append(this.decoratedRegion(regions[i], 0, stgy));
                    ++i;
                }
                this.appendDelimBefore(node, null, source);
            } else {
                int i = 0;
                while (i < regions.length) {
                    this.appendDelimBefore(node, regions[i], source);
                    source.append(this.decoratedRegion(regions[i], 0, stgy));
                    ++i;
                }
                this.appendDelimBefore(node, null, source);
            }
        } else if (child == null && prev != null && prev.getNodeType() != 12) {
            this.appendDelimBefore(node.getParentNode(), null, source);
        } else if (child != null && child.getNodeType() == 12 && ((MediaList)((Object)child)).getLength() > 0) {
            this.appendSpaceBefore(node, toAppend, source);
        } else if (prev != null && prev.getNodeType() == 12 && ((MediaList)((Object)prev)).getLength() > 0) {
            this.appendSpaceBefore(node, "{", source);
            source.append("{");
            if (child != null) {
                this.appendDelimBefore(node, null, source);
            } else {
                this.appendDelimBefore(node.getParentNode(), null, source);
            }
        } else {
            this.appendDelimBefore(node, null, source);
        }
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, IRegion region, String toAppend, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        if (child != null && child.getNodeType() == 12) {
            int i = 0;
            while (i < regions.length) {
                if (i != 0 || MediaRuleFormatter.needS(outside[0])) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            if (MediaRuleFormatter.needS(outside[1]) && ((IndexedRegion)child).getStartOffset() == region.getOffset() + region.getLength()) {
                this.appendSpaceBefore(node, toAppend, source);
            }
        } else if (child != null && (child.getPreviousSibling() == null || child.getPreviousSibling().getNodeType() == 12)) {
            int i = 0;
            while (i < regions.length) {
                if (i != 0 || MediaRuleFormatter.needS(outside[0])) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            if (MediaRuleFormatter.needS(outside[1]) && ((IndexedRegion)child).getStartOffset() == region.getOffset() + region.getLength()) {
                this.appendDelimBefore(node, null, source);
            }
        } else {
            int i = 0;
            while (i < regions.length) {
                if (i != 0 || MediaRuleFormatter.needS(outside[0])) {
                    this.appendDelimBefore(node, regions[i], source);
                }
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            if (MediaRuleFormatter.needS(outside[1]) && ((IndexedRegion)child).getStartOffset() == region.getOffset() + region.getLength()) {
                this.appendDelimBefore(node, null, source);
            }
        }
    }

    @Override
    protected void formatPost(ICSSNode node, StringBuffer source) {
        int start;
        int end = ((IndexedRegion)node).getEndOffset();
        int n = start = node.getLastChild() != null && ((IndexedRegion)node.getLastChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getLastChild()).getEndOffset() : this.getChildInsertPos(node);
        if (end > 0 && start < end) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            if (node.getLastChild() == null || node.getLastChild().getNodeType() != 12) {
                int i = 0;
                while (i < regions.length) {
                    this.appendDelimBefore(node, regions[i], source);
                    source.append(this.decoratedRegion(regions[i], 0, stgy));
                    ++i;
                }
            } else {
                boolean bInCurlyBrace = false;
                int i = 0;
                while (i < regions.length) {
                    if (!bInCurlyBrace) {
                        this.appendSpaceBefore(node, regions[i], source);
                    } else {
                        this.appendDelimBefore(node, regions[i], source);
                    }
                    source.append(this.decoratedRegion(regions[i], 0, stgy));
                    if (regions[i].getType() == "LBRACE") {
                        bInCurlyBrace = true;
                    }
                    ++i;
                }
            }
        } else {
            String delim = this.getLineDelimiter(node);
            if (node.getLastChild() != null && node.getLastChild().getNodeType() == 12) {
                this.appendSpaceBefore(node, "{", source);
                source.append("{");
            }
            source.append(delim);
            source.append(this.getIndent(node));
            source.append("}");
        }
    }

    @Override
    protected void formatPost(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || MediaRuleFormatter.needS(outside[0])) {
                this.appendDelimBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            ++i;
        }
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        int start = ((IndexedRegion)node).getStartOffset();
        int end = node.getFirstChild() != null && ((IndexedRegion)node.getFirstChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getFirstChild()).getStartOffset() : this.getChildInsertPos(node);
        ICSSNode child = node.getFirstChild();
        if (child != null && child instanceof MediaList && ((MediaList)((Object)child)).getLength() == 0) {
            end = child.getNextSibling() != null ? ((IndexedRegion)child.getNextSibling()).getStartOffset() : -1;
        }
        if (end > 0) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedIdentRegion(regions[i], stgy));
                ++i;
            }
        } else {
            String str = MEDIA;
            if (CSSCorePlugin.getDefault().getPluginPreferences().getInt("identifierCase") == 2) {
                str = MEDIA.toUpperCase();
            }
            source.append(str);
        }
        if (child != null && child instanceof MediaList && ((MediaList)((Object)child)).getLength() > 0) {
            this.appendSpaceBefore(node, "", source);
        }
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || MediaRuleFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedIdentRegion(regions[i], stgy));
            ++i;
        }
        if (MediaRuleFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    @Override
    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)node).getEndOffset();
        if (n > 0) {
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1);
            if (flatNode.getRegionAtCharacterOffset(n - 1).getType() == "LBRACE") {
                return n - 1;
            }
            return n;
        }
        return -1;
    }

    public static synchronized MediaRuleFormatter getInstance() {
        if (instance == null) {
            instance = new MediaRuleFormatter();
        }
        return instance;
    }

    @Override
    public int getLengthToReformatAfter(ICSSNode node, int insertPos) {
        if (node == null) {
            return 0;
        }
        IndexedRegion nnode = (IndexedRegion)node;
        if (insertPos <= 0 || !nnode.contains(insertPos - 1)) {
            return 0;
        }
        if (node.getFirstChild().getNextSibling() == node.getLastChild()) {
            int pos;
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(insertPos);
            if (flatNode == null) {
                return 0;
            }
            ITextRegion region = flatNode.getRegionAtCharacterOffset(insertPos);
            if (region == null) {
                return 0;
            }
            RegionIterator it = new RegionIterator(flatNode, region);
            while (it.hasNext()) {
                region = it.next();
                if (region.getType() == "LBRACE" || nnode.getEndOffset() <= it.getStructuredDocumentRegion().getEndOffset(region)) break;
            }
            return (pos = it.getStructuredDocumentRegion().getStartOffset(region) - insertPos) >= 0 ? pos : 0;
        }
        return super.getLengthToReformatAfter(node, insertPos);
    }

    @Override
    public int getLengthToReformatBefore(ICSSNode node, int insertPos) {
        if (node == null) {
            return 0;
        }
        IndexedRegion nnode = (IndexedRegion)node;
        if (insertPos <= 0 || !nnode.contains(insertPos - 1)) {
            return 0;
        }
        if (node.getFirstChild().getNextSibling() == node.getLastChild()) {
            int pos = ((IndexedRegion)node.getFirstChild()).getEndOffset();
            if (pos <= 0) {
                pos = ((IndexedRegion)node).getStartOffset() + 6;
            }
            return insertPos - pos;
        }
        return super.getLengthToReformatBefore(node, insertPos);
    }
}

