/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.edit.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupProcessorImpl;
import org.eclipse.wst.html.ui.internal.edit.ui.CleanupDialogHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class CleanupDocumentHandler
extends AbstractHandler
implements IHandler {
    private IStructuredCleanupProcessor fCleanupProcessor;

    public void dispose() {
        this.fCleanupProcessor = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editorPart instanceof ITextEditor) {
            textEditor = (ITextEditor)editorPart;
        } else {
            Object o = editorPart.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null) {
            final ITextEditor editor = textEditor;
            CleanupDialogHTML cleanupDialog = new CleanupDialogHTML(editor.getSite().getShell());
            cleanupDialog.setisXHTMLType(this.isXHTML(editor));
            if (cleanupDialog.open() == 0) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IStructuredCleanupProcessor cleanupProcessor = CleanupDocumentHandler.this.getCleanupProcessor();
                        if (cleanupProcessor != null) {
                            IStructuredModel model = null;
                            try {
                                model = StructuredModelManager.getModelManager().getExistingModelForEdit(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
                                if (model != null) {
                                    if (cleanupProcessor instanceof AbstractStructuredCleanupProcessor && editor instanceof StructuredTextEditor) {
                                        ((AbstractStructuredCleanupProcessor)cleanupProcessor).cleanupModel(model, (Object)((StructuredTextEditor)editor).getTextViewer());
                                    } else {
                                        cleanupProcessor.cleanupModel(model);
                                    }
                                }
                            }
                            finally {
                                if (model != null) {
                                    model.releaseFromEdit();
                                }
                            }
                        }
                    }
                };
                IStructuredModel model = null;
                try {
                    model = StructuredModelManager.getModelManager().getExistingModelForEdit(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
                    if (model != null) {
                        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                        model.beginRecording((Object)this, SSEUIMessages.Cleanup_Document_UI_, SSEUIMessages.Cleanup_Document_UI_, selection.getOffset(), selection.getLength());
                        model.aboutToChangeModel();
                        BusyIndicator.showWhile((Display)editor.getEditorSite().getWorkbenchWindow().getShell().getDisplay(), (Runnable)runnable);
                    }
                }
                finally {
                    if (model != null) {
                        model.changedModel();
                        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                        model.endRecording((Object)this, selection.getOffset(), selection.getLength());
                        model.releaseFromEdit();
                    }
                }
            }
        }
        return null;
    }

    IStructuredCleanupProcessor getCleanupProcessor() {
        if (this.fCleanupProcessor == null) {
            this.fCleanupProcessor = new HTMLCleanupProcessorImpl();
        }
        return this.fCleanupProcessor;
    }

    private boolean isXHTML(ITextEditor editor) {
        boolean isxhtml = false;
        if (editor != null) {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IStructuredModel model = null;
            try {
                IDOMDocument domDocument;
                model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                if (model instanceof IDOMModel && (domDocument = ((IDOMModel)model).getDocument()) != null) {
                    isxhtml = domDocument.isXMLType();
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return isxhtml;
    }
}

