/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.efs.ChromiumScriptFileSystem;
import org.eclipse.wst.jsdt.chromium.debug.core.util.UniqueKeyGenerator;

public class ChromiumDebugPluginUtil {
    private static final String CHROMIUM_EXTENSION = "chromium";
    public static final Set<String> SUPPORTED_EXTENSIONS = new HashSet<String>(Arrays.asList("chromium", "js", "html", "htm"));
    public static final List<String> SUPPORTED_EXTENSIONS_SUFFIX_LIST = new ArrayList<String>(SUPPORTED_EXTENSIONS.size());
    public static final String JS_DEBUG_PROJECT_NATURE = "org.eclipse.wst.jsdt.chromium.debug.core.jsnature";
    public static final String CHROMIUM_EXTENSION_SUFFIX = ".chromium";
    private static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private static final Pattern FILE_NAME_BAD_CHARS;
    private static final Pattern FILE_NAME_BAD_CHARS_FALLBACK;
    public static final Breakpoint.Target.Visitor<String> BREAKPOINT_TARGET_TO_STRING;

    static {
        for (String extension : SUPPORTED_EXTENSIONS) {
            SUPPORTED_EXTENSIONS_SUFFIX_LIST.add("." + extension);
        }
        FILE_NAME_BAD_CHARS = Pattern.compile("[/\\x00]");
        FILE_NAME_BAD_CHARS_FALLBACK = Pattern.compile("[^\\w\\._-]");
        BREAKPOINT_TARGET_TO_STRING = new BreakpointTypeExtension.ScriptRegExpSupport.Visitor<String>(){

            public String visitScriptName(String scriptName) {
                return "script_name=" + scriptName;
            }

            public String visitScriptId(Object scriptId) {
                return "script_id=" + scriptId;
            }

            public String visitRegExp(String regExp) {
                return "RegExp=" + regExp;
            }

            public String visitUnknown(Breakpoint.Target target) {
                return "Unknown target: + " + target;
            }
        };
    }

    public static void openProjectExplorerView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null && workbench.getWorkbenchWindowCount() == 1) {
                    window = workbench.getWorkbenchWindows()[0];
                }
                if (window != null) {
                    try {
                        window.getActivePage().showView(ChromiumDebugPluginUtil.PROJECT_EXPLORER_ID);
                    }
                    catch (PartInitException partInitException) {}
                }
            }
        });
    }

    public static IProject createEmptyProject(String projectNameBase) {
        ProjectCheckData projectProject;
        try {
            String projectNameTry;
            int uniqueNumber = 0;
            while ((projectProject = ChromiumDebugPluginUtil.checkProjectName(projectNameTry = uniqueNumber == 0 ? projectNameBase : String.valueOf(projectNameBase) + " (" + uniqueNumber + ")")) == null) {
                ++uniqueNumber;
            }
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log(e);
            return null;
        }
        IProject project = projectProject.getProject();
        if (project.exists()) {
            try {
                project.delete(true, null);
            }
            catch (CoreException e) {
                ChromiumDebugPlugin.log(e);
                return null;
            }
        }
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        description.setLocationURI(projectProject.getProjectUri());
        description.setNatureIds(new String[]{JS_DEBUG_PROJECT_NATURE});
        try {
            project.create(description, null);
            project.open(null);
            return project;
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log(e);
            return null;
        }
    }

    private static ProjectCheckData checkProjectName(String projectNameTry) throws CoreException {
        URI projectURI;
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectNameTry);
        if (project.exists() && !ChromiumScriptFileSystem.isChromiumDebugURI(projectURI = project.getLocationURI())) {
            return null;
        }
        IPath newPath = project.getFullPath();
        final URI projectUriTry = ChromiumScriptFileSystem.getFileStoreUri(newPath);
        IFileStore projectStore = EFS.getStore((URI)projectUriTry);
        if (projectStore.fetchInfo().exists()) {
            return null;
        }
        return new ProjectCheckData(){

            @Override
            public IProject getProject() {
                return project;
            }

            @Override
            public URI getProjectUri() {
                return projectUriTry;
            }
        };
    }

    public static void deleteVirtualProjectAsync(final IProject debugProject) {
        Job job = new Job("Remove virtual project"){

            protected IStatus run(IProgressMonitor monitor) {
                URI projectUri = debugProject.getLocationURI();
                try {
                    IFileStore projectStore = EFS.getStore((URI)projectUri);
                    if (projectStore.fetchInfo().exists()) {
                        projectStore.delete(0, null);
                    }
                    debugProject.delete(true, null);
                }
                catch (CoreException e) {
                    ChromiumDebugPlugin.log(e);
                    return new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Failed to delete virtual project");
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static boolean projectExists(String projectName) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject proj = ws.getRoot().getProject(projectName);
        return proj.exists();
    }

    public static IFile createFile(IProject container, String filename) {
        return ChromiumDebugPluginUtil.createFile(container, FileContainerHandler.FOR_PROJECT, filename);
    }

    public static IFile createFile(IFolder container, String filename) {
        return ChromiumDebugPluginUtil.createFile(container, FileContainerHandler.FOR_FOLDER, filename);
    }

    private static <C> IFile createFile(final C container, final FileContainerHandler<C> handler, String filename) {
        String patchedName = FILE_NAME_BAD_CHARS.matcher(filename).replaceAll("_");
        if (!ResourcesPlugin.getWorkspace().validateName(patchedName, 1).isOK()) {
            patchedName = FILE_NAME_BAD_CHARS_FALLBACK.matcher(filename).replaceAll("_");
        }
        UniqueKeyGenerator.Factory<IFile> factory = new UniqueKeyGenerator.Factory<IFile>(){

            @Override
            public IFile tryCreate(String uniqueName) {
                String filePathname = String.valueOf(uniqueName) + ChromiumDebugPluginUtil.CHROMIUM_EXTENSION_SUFFIX;
                IFile file = handler.getFile(container, filePathname);
                if (file.exists()) {
                    return null;
                }
                try {
                    file.create((InputStream)new ByteArrayInputStream("".getBytes()), false, null);
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status instanceof IResourceStatus && status.getCode() == 275) {
                        return null;
                    }
                    throw new RuntimeException(e);
                }
                return file;
            }
        };
        return UniqueKeyGenerator.createUniqueKey(patchedName, 1000, factory);
    }

    public static void writeFile(IFile file, String data) throws CoreException {
        if (file != null && file.exists()) {
            ResourceAttributes resourceAttributes = file.getResourceAttributes();
            if (resourceAttributes.isReadOnly()) {
                resourceAttributes.setReadOnly(false);
                file.setResourceAttributes(resourceAttributes);
            }
            file.setContents((InputStream)new ByteArrayInputStream(data.getBytes()), 1, null);
            resourceAttributes.setReadOnly(true);
            file.setResourceAttributes(resourceAttributes);
        }
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static IContainer getSourceContainer(IProject project) {
        return project;
    }

    public static byte[] readFileContents(IFile file) throws IOException, CoreException {
        try (InputStream inputStream = file.getContents();){
            byte[] byArray = ChromiumDebugPluginUtil.readBytes(inputStream);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        int len;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] array = new byte[1024];
        while ((len = bufferedInputStream.read(array)) != -1) {
            output.write(array, 0, len);
        }
        return output.toByteArray();
    }

    public static <T> T throwUnsupported() {
        throw new UnsupportedOperationException();
    }

    private ChromiumDebugPluginUtil() {
    }

    private static abstract class FileContainerHandler<T> {
        static final FileContainerHandler<IProject> FOR_PROJECT = new FileContainerHandler<IProject>(){

            @Override
            IFile getFile(IProject project, String name) {
                return project.getFile(name);
            }
        };
        static final FileContainerHandler<IFolder> FOR_FOLDER = new FileContainerHandler<IFolder>(){

            @Override
            IFile getFile(IFolder folder, String name) {
                return folder.getFile(name);
            }
        };

        private FileContainerHandler() {
        }

        abstract IFile getFile(T var1, String var2);
    }

    private static interface ProjectCheckData {
        public IProject getProject();

        public URI getProjectUri();
    }
}

