/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.ui.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.ui.plugin.WSUIPlugin;
import org.eclipse.wst.ws.internal.util.UniversalPathTransformer;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class OpenEditorCommand
extends AbstractDataModelOperation {
    private IWebService webService;
    private IContext context;

    public void setWebService(IWebService webService) {
        this.webService = webService;
    }

    public void setContext(IContext context) {
        this.context = context;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.context.getScenario().getValue() != 1) {
            return Status.OK_STATUS;
        }
        String[] implURLs = this.webService.getWebServiceInfo().getImplURLs();
        if (implURLs == null) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < implURLs.length) {
            try {
                IWorkbenchPage page;
                String implURL = implURLs[i];
                IFile file = UniversalPathTransformer.toFile((String)implURL);
                if (file != null && file.exists() && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (Exception e) {
                WSUIPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.wst.ws.ui", 0, e.getMessage(), (Throwable)e));
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

