/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.document.CharOperation;
import org.eclipse.wst.xml.core.internal.document.CharacterStringPool;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttrImpl
extends NodeImpl
implements IDOMAttr {
    private ITextRegion equalRegion = null;
    private char[] fName = null;
    private ITextRegion nameRegion = null;
    private ElementImpl ownerElement = null;
    private ITextRegion fValueRegion = null;
    private char[] fValueSource = null;
    private char[] fNamespaceURI = null;

    protected AttrImpl() {
    }

    protected AttrImpl(AttrImpl that) {
        super(that);
        if (that != null) {
            this.fName = that.fName;
            String valueSource = that.getValueSource();
            if (valueSource != null) {
                this.fValueSource = valueSource.toCharArray();
            }
        }
    }

    @Override
    public Node cloneNode(boolean deep) {
        AttrImpl cloned = new AttrImpl(this);
        this.notifyUserDataHandlers((short)1, cloned);
        return cloned;
    }

    protected CMAttributeDeclaration getDeclaration() {
        ElementImpl element = (ElementImpl)this.getOwnerElement();
        if (element == null) {
            return null;
        }
        CMElementDeclaration elementDecl = element.getDeclaration();
        if (elementDecl == null) {
            return null;
        }
        List nodes = ModelQueryUtil.getModelQuery(this.getOwnerDocument()).getAvailableContent(this.getOwnerElement(), elementDecl, 1);
        String name = this.getName();
        int k = 0;
        while (k < nodes.size()) {
            CMNode cmnode = (CMNode)nodes.get(k);
            if (cmnode.getNodeType() == 2 && name.equals(cmnode.getNodeName())) {
                return (CMAttributeDeclaration)cmnode;
            }
            ++k;
        }
        return null;
    }

    @Override
    public int getEndOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        int offset = this.ownerElement.getStartOffset();
        if (this.fValueRegion != null) {
            return offset + this.fValueRegion.getEnd();
        }
        if (this.equalRegion != null) {
            return offset + this.equalRegion.getEnd();
        }
        if (this.nameRegion != null) {
            return offset + this.nameRegion.getEnd();
        }
        return 0;
    }

    @Override
    public ITextRegion getEqualRegion() {
        return this.equalRegion;
    }

    @Override
    public String getLocalName() {
        if (this.fName == null) {
            return null;
        }
        int index = CharOperation.indexOf(this.fName, ':');
        if (index < 0) {
            return new String(this.fName);
        }
        return new String(this.fName, index + 1, this.fName.length - index - 1);
    }

    @Override
    public String getName() {
        if (this.fName == null) {
            return "";
        }
        return new String(this.fName);
    }

    @Override
    public ITextRegion getNameRegion() {
        return this.nameRegion;
    }

    @Override
    public int getNameRegionEndOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return 0;
        }
        return flatNode.getEndOffset(this.nameRegion);
    }

    @Override
    public int getNameRegionStartOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return 0;
        }
        return flatNode.getStartOffset(this.nameRegion);
    }

    @Override
    public String getNameRegionText() {
        if (this.ownerElement == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        return flatNode.getText(this.nameRegion);
    }

    @Override
    public int getNameRegionTextEndOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return 0;
        }
        return flatNode.getTextEndOffset(this.nameRegion);
    }

    @Override
    public String getNamespaceURI() {
        String nsAttrName = null;
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            if (prefix.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
        } else {
            String name = this.getName();
            if (name != null && name.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            if (this.fNamespaceURI == null) {
                return null;
            }
            return new String(this.fNamespaceURI);
        }
        nsAttrName = "xmlns:" + prefix;
        Node node = this.ownerElement;
        while (node != null) {
            if (node.getNodeType() != 1) break;
            Element element = node;
            Attr attr = element.getAttributeNode(nsAttrName);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        if (this.fNamespaceURI == null) {
            return null;
        }
        return new String(this.fNamespaceURI);
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public Element getOwnerElement() {
        return this.ownerElement;
    }

    @Override
    public String getPrefix() {
        if (this.fName == null) {
            return null;
        }
        int index = CharOperation.indexOf(this.fName, ':');
        if (index <= 0) {
            return null;
        }
        if (this.fName[0] == '<') {
            return null;
        }
        return new String(this.fName, 0, index);
    }

    @Override
    public boolean getSpecified() {
        return this.fValueRegion != null;
    }

    @Override
    public int getStartOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        int offset = this.ownerElement.getStartOffset();
        if (this.nameRegion != null) {
            return offset + this.nameRegion.getStart();
        }
        if (this.equalRegion != null) {
            return offset + this.equalRegion.getStart();
        }
        if (this.fValueRegion != null) {
            return offset + this.fValueRegion.getStart();
        }
        return 0;
    }

    @Override
    public String getValue() {
        return this.getValue(this.getValueSource());
    }

    private String getValue(String source) {
        if (source == null) {
            return "";
        }
        if (source.length() == 0) {
            return source;
        }
        StringBuffer buffer = null;
        int offset = 0;
        int length = source.length();
        int ref = source.indexOf(38);
        while (ref >= 0) {
            String name;
            String value;
            int end = source.indexOf(59, ref + 1);
            if (end > ref + 1 && (value = this.getCharValue(name = source.substring(ref + 1, end))) != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                }
                if (ref > offset) {
                    buffer.append(source.substring(offset, ref));
                }
                buffer.append(value);
                offset = end + 1;
                ref = end;
            }
            ref = source.indexOf(38, ref + 1);
        }
        if (buffer == null) {
            return source;
        }
        if (length > offset) {
            buffer.append(source.substring(offset));
        }
        return buffer.toString();
    }

    @Override
    public ITextRegion getValueRegion() {
        return this.fValueRegion;
    }

    @Override
    public int getValueRegionStartOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion structuredDocumentRegion = this.ownerElement.getFirstStructuredDocumentRegion();
        if (structuredDocumentRegion == null) {
            return 0;
        }
        if (this.fValueRegion == null) {
            return 0;
        }
        return structuredDocumentRegion.getStartOffset(this.fValueRegion);
    }

    @Override
    public String getValueRegionText() {
        if (this.ownerElement == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        if (this.fValueRegion == null) {
            return null;
        }
        return flatNode.getText(this.fValueRegion);
    }

    @Override
    public String getValueSource() {
        if (this.fValueSource != null) {
            return new String(this.fValueSource);
        }
        if (this.ownerElement == null) {
            return null;
        }
        IStructuredDocumentRegion ownerRegion = this.ownerElement.getStartStructuredDocumentRegion();
        if (ownerRegion == null) {
            return null;
        }
        if (this.fValueRegion != null) {
            return StructuredDocumentRegionUtil.getAttrValue(ownerRegion, this.fValueRegion);
        }
        return "";
    }

    private String getValueSource(ElementImpl ownerElement) {
        if (this.fValueSource != null) {
            return new String(this.fValueSource);
        }
        if (this.fValueRegion != null) {
            return StructuredDocumentRegionUtil.getAttrValue(ownerElement.getStructuredDocumentRegion(), this.fValueRegion);
        }
        return "";
    }

    private String getValueSource(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        StringBuffer buffer = null;
        int offset = 0;
        int length = value.length();
        int amp = value.indexOf(38);
        while (amp >= 0) {
            if (buffer == null) {
                buffer = new StringBuffer(length + 4);
            }
            if (amp > offset) {
                buffer.append(value.substring(offset, amp));
            }
            buffer.append("&amp;");
            offset = amp + 1;
            amp = value.indexOf(38, offset);
        }
        if (buffer == null) {
            return value;
        }
        if (length > offset) {
            buffer.append(value.substring(offset));
        }
        return buffer.toString();
    }

    @Override
    public boolean hasNestedValue() {
        if (this.fValueRegion == null) {
            return false;
        }
        if (!(this.fValueRegion instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)this.fValueRegion).getRegions();
        if (regions == null) {
            return false;
        }
        for (ITextRegion region : regions) {
            String regionType;
            if (region == null || (regionType = region.getType()) != "XML_TAG_OPEN" && !this.isNestedLanguageOpening(regionType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNameOnly() {
        return this.nameRegion != null && this.equalRegion == null && this.fValueRegion == null;
    }

    protected final boolean hasPrefix() {
        if (this.fName == null || this.fName.length == 0) {
            return false;
        }
        return CharOperation.indexOf(this.fName, ':') > 0 && this.fName[0] != '<';
    }

    protected final boolean ignoreCase() {
        DocumentImpl document;
        if (this.ownerElement != null ? this.ownerElement.ignoreCase() : (document = (DocumentImpl)this.getOwnerDocument()) != null && document.ignoreCase()) {
            return !this.hasPrefix();
        }
        return false;
    }

    @Override
    public boolean isGlobalAttr() {
        if (this.hasPrefix()) {
            return false;
        }
        if (this.ownerElement == null) {
            return false;
        }
        return this.ownerElement.isGlobalTag();
    }

    @Override
    public final boolean isXMLAttr() {
        DocumentImpl document;
        if (this.ownerElement != null ? !this.ownerElement.isXMLTag() : (document = (DocumentImpl)this.getOwnerDocument()) != null && !document.isXMLType()) {
            return this.hasPrefix();
        }
        return true;
    }

    protected boolean matchName(String name) {
        if (name == null) {
            return this.fName == null;
        }
        if (this.fName == null) {
            return false;
        }
        return CharOperation.equals(this.fName, name.toCharArray(), this.ignoreCase());
    }

    protected boolean matchName(char[] name) {
        if (name == null) {
            return this.fName == null;
        }
        if (this.fName == null) {
            return false;
        }
        return CharOperation.equals(this.fName, name, this.ignoreCase());
    }

    protected void notifyNameChanged() {
        if (this.ownerElement == null) {
            return;
        }
        DocumentImpl document = (DocumentImpl)this.ownerElement.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.nameChanged(this);
    }

    @Override
    protected void notifyValueChanged() {
        if (this.ownerElement == null) {
            return;
        }
        DocumentImpl document = (DocumentImpl)this.ownerElement.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.valueChanged(this);
    }

    void removeRegions() {
        this.nameRegion = null;
        this.fValueRegion = null;
        this.equalRegion = null;
    }

    void resetRegions() {
        this.fValueSource = this.getValueSource().toCharArray();
        this.removeRegions();
    }

    void resetRegions(ElementImpl ownerElement) {
        this.fValueSource = this.getValueSource(ownerElement).toCharArray();
        this.removeRegions();
    }

    void setEqualRegion(ITextRegion equalRegion) {
        this.equalRegion = equalRegion;
    }

    protected void setName(String name) {
        String value = null;
        int startOffset = 0;
        if (this.ownerElement != null) {
            value = this.getValue();
            startOffset = this.ownerElement.getStartOffset();
            this.ownerElement.notify(3, this, value, null, startOffset);
        }
        this.fName = CharacterStringPool.getCharString(name);
        if (this.ownerElement != null) {
            this.ownerElement.notify(2, this, null, value, startOffset);
        }
    }

    void setNameRegion(ITextRegion nameRegion) {
        this.nameRegion = nameRegion;
    }

    protected void setNamespaceURI(String namespaceURI) {
        this.fNamespaceURI = (char[])(namespaceURI == null ? null : namespaceURI.toCharArray());
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.setValue(nodeValue);
    }

    protected void setOwnerElement(Element ownerElement) {
        this.ownerElement = (ElementImpl)ownerElement;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if (this.ownerElement != null && !this.ownerElement.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        int prefixLength = prefix != null ? prefix.length() : 0;
        String localName = this.getLocalName();
        if (prefixLength == 0) {
            this.setName(localName);
            return;
        }
        if (localName == null) {
            localName = "";
        }
        int localLength = localName.length();
        StringBuffer buffer = new StringBuffer(prefixLength + 1 + localLength);
        buffer.append(prefix);
        buffer.append(':');
        buffer.append(localName);
        this.setName(buffer.toString());
        this.notifyNameChanged();
    }

    @Override
    public void setValue(String value) {
        try {
            this.getModel().aboutToChangeModel();
            this.setValueSource(this.getValueSource(value));
        }
        finally {
            this.getModel().changedModel();
        }
    }

    void setValueRegion(ITextRegion valueRegion) {
        this.fValueRegion = valueRegion;
        if (valueRegion != null) {
            this.fValueSource = null;
        }
    }

    @Override
    public void setValueSource(String source) {
        if (this.ownerElement != null && !this.ownerElement.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        this.fValueSource = source != null ? source.toCharArray() : null;
        this.notifyValueChanged();
    }

    protected boolean isNestedLanguageOpening(String regionType) {
        boolean result = false;
        return result;
    }
}

