/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search.quickscan;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.wst.common.core.search.document.ComponentDeclarationEntry;
import org.eclipse.wst.common.core.search.document.ComponentReferenceEntry;
import org.eclipse.wst.common.core.search.document.Entry;
import org.eclipse.wst.common.core.search.document.FileReferenceEntry;
import org.eclipse.wst.common.core.search.document.SearchDocument;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentDeclarationPattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentReferencePattern;
import org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher;
import org.eclipse.wst.xml.core.internal.search.matching.SAXSearchElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLQuickScanContentHandler
extends DefaultHandler {
    private Map namespaceMap = new HashMap();
    private String targetNamespace = "";
    private SearchPattern pattern;
    private SearchDocument document;
    private SAXSearchElement searchElement = new SAXSearchElement();
    private boolean hasMatch = false;
    private Stack currentPath = new Stack();
    private PatternMatcher matcher;
    public static final String XMLSCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    public XMLQuickScanContentHandler(PatternMatcher matcher, SearchPattern pattern) {
        this.pattern = pattern;
        this.matcher = matcher;
    }

    public XMLQuickScanContentHandler(SearchDocument document, PatternMatcher matcher, SearchPattern pattern) {
        this.pattern = pattern;
        this.matcher = matcher;
        this.document = document;
    }

    public XMLQuickScanContentHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.targetNamespace.equals("")) {
            int nAttributes = attributes.getLength();
            int i = 0;
            while (i < nAttributes) {
                if ("targetNamespace".equals(attributes.getQName(i))) {
                    this.targetNamespace = attributes.getValue(i);
                    break;
                }
                ++i;
            }
        }
        if ("import".equals(localName) && this.namespaceMatches(uri)) {
            FileReferenceEntry documentEntry = new FileReferenceEntry();
            documentEntry.setCategory("outLink");
            documentEntry.setKey("import");
            String namespace = attributes.getValue("namespace");
            String location = attributes.getValue(this.getLocationAttributeName(uri));
            documentEntry.setPublicIdentifier(namespace);
            documentEntry.setRelativeFilePath(location);
            this.document.putEntry((Entry)documentEntry);
        }
        if (("redefine".equals(localName) || "include".equals(localName)) && this.namespaceMatches(uri)) {
            FileReferenceEntry documentEntry = new FileReferenceEntry();
            documentEntry.setCategory("outLink");
            documentEntry.setKey("include");
            String location = attributes.getValue(this.getLocationAttributeName(uri));
            documentEntry.setPublicIdentifier(uri);
            documentEntry.setRelativeFilePath(location);
            this.document.putEntry((Entry)documentEntry);
        }
        this.searchElement.setElementName(localName);
        this.searchElement.setElementNamespace(uri);
        this.searchElement.setAttributes(attributes);
        this.searchElement.setNamespaceMap(this.namespaceMap);
        this.searchElement.setTargetNamespace(this.targetNamespace);
        if (this.currentPath.size() > 0) {
            String parentName = (String)this.currentPath.peek();
            this.searchElement.setParentName(parentName);
        }
        if (this.matcher != null && this.matcher.matches(this.pattern, this.searchElement)) {
            this.hasMatch = true;
            if (this.pattern instanceof XMLComponentReferencePattern) {
                ComponentReferenceEntry documentEntry = new ComponentReferenceEntry();
                documentEntry.setCategory("componentDecl");
                QualifiedName name = new QualifiedName(uri, localName);
                documentEntry.setKey(name.toString());
                documentEntry.setName(name);
                this.document.putEntry((Entry)documentEntry);
            } else if (this.pattern instanceof XMLComponentDeclarationPattern) {
                ComponentDeclarationEntry documentEntry = new ComponentDeclarationEntry();
                documentEntry.setCategory("componentDecl");
                QualifiedName name = new QualifiedName(this.targetNamespace, attributes.getValue("name"));
                QualifiedName metaName = new QualifiedName(uri, localName);
                documentEntry.setKey(name.toString());
                documentEntry.setName(name);
                documentEntry.setMetaName(metaName);
                this.document.putEntry((Entry)documentEntry);
            }
        }
        this.currentPath.push(localName);
    }

    private String getLocationAttributeName(String uri) {
        if (XMLSCHEMA_NAMESPACE.equals(uri)) {
            return "schemaLocation";
        }
        if (WSDL_NAMESPACE.equals(uri)) {
            return "location";
        }
        return "";
    }

    private boolean namespaceMatches(String uri) {
        return XMLSCHEMA_NAMESPACE.equals(uri) || WSDL_NAMESPACE.equals(uri);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentPath.pop();
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        if (arg0 != null && arg0.length() > 0) {
            this.namespaceMap.put(arg0, arg1);
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public boolean hasMatch() {
        return this.hasMatch;
    }
}

