/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.actions.AbstractNodeActionManager;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.dialogs.EditElementDialog;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditElementAction
extends NodeAction {
    protected static ImageDescriptor imageDescriptor;
    protected Element element;
    protected int insertionIndex = -1;
    protected AbstractNodeActionManager manager;
    protected Node parent;
    protected String title;

    public static ImageDescriptor createImageDescriptor() {
        if (imageDescriptor == null) {
            imageDescriptor = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/element_obj.gif");
        }
        return imageDescriptor;
    }

    public EditElementAction(AbstractNodeActionManager manager, Element element, String actionLabel, String dialogTitle) {
        this(manager, element.getParentNode(), -1, element, actionLabel, dialogTitle);
    }

    protected EditElementAction(AbstractNodeActionManager manager, Node parent, int index, Element element, String actionLabel, String title) {
        this.manager = manager;
        this.parent = parent;
        this.insertionIndex = index;
        this.element = element;
        this.title = title;
        this.setText(actionLabel);
        if (element == null) {
            this.setImageDescriptor(EditElementAction.createImageDescriptor());
        }
    }

    public EditElementAction(AbstractNodeActionManager manager, Node parent, int index, String actionLabel, String title) {
        this(manager, parent, index, null, actionLabel, title);
    }

    @Override
    public String getUndoDescription() {
        return this.title;
    }

    public void run() {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.validateEdit(this.manager.getModel(), shell)) {
            this.manager.beginNodeAction(this);
            EditElementDialog dialog = new EditElementDialog(shell, this.element);
            dialog.create();
            dialog.getShell().setText(this.title);
            dialog.setBlockOnOpen(true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Document document;
                Document document2 = document = this.parent.getNodeType() == 9 ? (Document)this.parent : this.parent.getOwnerDocument();
                if (this.element != null) {
                    if (this.element instanceof IDOMElement) {
                        IDOMElement elementImpl = (IDOMElement)this.element;
                        IDOMModel model = elementImpl.getModel();
                        String oldName = elementImpl.getNodeName();
                        String newName = dialog.getElementName();
                        this.setStructuredDocumentRegionElementName(model, elementImpl.getStartStructuredDocumentRegion(), oldName, newName);
                        this.setStructuredDocumentRegionElementName(model, elementImpl.getEndStructuredDocumentRegion(), oldName, newName);
                    }
                } else {
                    Element newElement = document.createElement(dialog.getElementName());
                    NodeList nodeList = this.parent.getChildNodes();
                    int nodeListLength = nodeList.getLength();
                    Node refChild = this.insertionIndex < nodeListLength && this.insertionIndex >= 0 ? nodeList.item(this.insertionIndex) : null;
                    this.parent.insertBefore(newElement, refChild);
                    this.manager.reformat(newElement, false);
                    this.manager.setViewerSelection(newElement);
                }
            }
            this.manager.endNodeAction(this);
        }
    }

    protected void setStructuredDocumentRegionElementName(IDOMModel model, IStructuredDocumentRegion flatNode, String oldName, String newName) {
        String string;
        int index;
        if (flatNode != null && (index = (string = flatNode.getText()).indexOf(oldName)) != -1) {
            model.getStructuredDocument().replaceText((Object)this, index += flatNode.getStart(), oldName.length(), newName);
        }
    }
}

