/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSGMonthDay
extends CalendarType
implements CmpEq {
    private static final String XS_G_MONTH_DAY = "xs:gMonthDay";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;

    public XSGMonthDay(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        if (tz != null) {
            this._timezoned = true;
            this._tz = tz;
        }
    }

    public XSGMonthDay() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    @Override
    public String type_name() {
        return "gMonthDay";
    }

    public static XSGMonthDay parse_gMonthDay(String str) {
        XSDateTime dt;
        String startdate = "1972-";
        String starttime = "T00:00:00";
        int index = str.lastIndexOf(43, str.length());
        if (index == -1) {
            index = str.lastIndexOf(45);
        }
        if (index == -1) {
            index = str.lastIndexOf(90, str.length());
        }
        if (index != -1) {
            int zIndex = str.lastIndexOf(90, str.length());
            if (zIndex == -1 && index > 5) {
                zIndex = index;
            }
            if (zIndex == -1) {
                zIndex = str.lastIndexOf(43);
            }
            String[] split = str.split("-");
            startdate = String.valueOf(startdate) + split[2].replaceAll("Z", "") + "-" + split[3].replaceAll("Z", "").substring(0, 2);
            if (split.length > 4) {
                String[] timesplit = split[4].split(":");
                if (timesplit.length < 3) {
                    starttime = "T";
                    StringBuffer buf = new StringBuffer(starttime);
                    int cnt = 0;
                    while (cnt < timesplit.length) {
                        buf.append(String.valueOf(timesplit[cnt]) + ":");
                        ++cnt;
                    }
                    buf.append("00");
                    starttime = buf.toString();
                } else {
                    starttime = String.valueOf(starttime) + timesplit[0] + ":" + timesplit[1] + ":" + timesplit[2];
                }
            }
            startdate = startdate.trim();
            startdate = String.valueOf(startdate) + starttime;
            if (zIndex != -1) {
                startdate = String.valueOf(startdate) + str.substring(zIndex);
            }
        } else {
            startdate = String.valueOf(startdate) + starttime;
        }
        if ((dt = XSDateTime.parseDateTime(startdate)) == null) {
            return null;
        }
        return new XSGMonthDay(dt.calendar(), dt.tz());
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof XSTime || this.isGDataType(aat) || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSGMonthDay val = this.castGMonthDay(aat);
        if (val == null) {
            throw DynamicError.cant_cast(null);
        }
        return val;
    }

    protected boolean isGDataType(AnyAtomicType aat) {
        String type = aat.string_type();
        return type.equals("xs:gDay") || type.equals("xs:gMonth") || type.equals("xs:gYear") || type.equals("xs:gYearMonth");
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        return aat instanceof XSDate || aat instanceof XSDateTime || aat instanceof XSGMonthDay;
    }

    private XSGMonthDay castGMonthDay(AnyAtomicType aat) {
        if (aat instanceof XSGMonthDay) {
            XSGMonthDay gmd = (XSGMonthDay)aat;
            return new XSGMonthDay(gmd.calendar(), gmd.tz());
        }
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSGMonthDay(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSGMonthDay(dateTime.calendar(), dateTime.tz());
        }
        return XSGMonthDay.parse_gMonthDay(aat.getStringValue());
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    @Override
    public String getStringValue() {
        String ret = "--";
        Calendar adjustFortimezone = this.calendar();
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.month(), 2);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(adjustFortimezone.get(5), 2);
        if (this.timezoned()) {
            int hrs = this.tz().hours();
            int min = this.tz().minutes();
            double secs = this.tz().seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = String.valueOf(ret) + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this.tz().negative() ? String.valueOf(tZoneStr) + "-" : String.valueOf(tZoneStr) + "+";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(hrs, 2);
                tZoneStr = String.valueOf(tZoneStr) + ":";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(min, 2);
                ret = String.valueOf(ret) + tZoneStr;
            }
        }
        return ret;
    }

    @Override
    public String string_type() {
        return XS_G_MONTH_DAY;
    }

    @Override
    public Calendar calendar() {
        return this._calendar;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        XSGMonthDay val = (XSGMonthDay)NumericType.get_single_type(arg, XSGMonthDay.class);
        return this.calendar().equals(val.calendar());
    }

    public XSDuration tz() {
        return this._tz;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_GMONTHDAY;
    }
}

