/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.common.actions.XSDBaseAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.DeleteCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;

public class DeleteXSDConcreteComponentAction
extends XSDBaseAction {
    public static final String DELETE_XSD_COMPONENT_ID = "org.eclipse.wst.xsd.ui.internal.common.actions.DeleteXSDConcreteComponentAction";

    public DeleteXSDConcreteComponentAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages._UI_ACTION_DELETE);
        this.setId(DELETE_XSD_COMPONENT_ID);
        this.setImageDescriptor(XSDEditorPlugin.getImageDescriptor("icons/delete_obj.gif"));
    }

    public void run() {
        Iterator i = ((IStructuredSelection)this.getSelection()).iterator();
        while (i.hasNext()) {
            Adapter adapter;
            Object selection = i.next();
            boolean doReselect = false;
            if (selection instanceof XSDBaseAdapter) {
                selection = ((XSDBaseAdapter)selection).getTarget();
            }
            if (!(selection instanceof XSDConcreteComponent)) continue;
            XSDConcreteComponent xsdComponent = (XSDConcreteComponent)selection;
            XSDSchema model = xsdComponent.getSchema();
            doReselect = xsdComponent.eContainer() instanceof XSDSchema;
            DeleteCommand command = new DeleteCommand(this.getText(), xsdComponent);
            this.getCommandStack().execute((Command)command);
            if (model == null || !doReselect || (adapter = XSDAdapterFactory.getInstance().adapt((Notifier)model)) == null) continue;
            this.provider.setSelection((ISelection)new StructuredSelection((Object)adapter));
        }
    }
}

