/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SelectFromCatalogDialog;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class AddNewCategoryDialog
extends Dialog {
    private static final String SCHEMA_LABEL = Messages._UI_LABEL_SCHEMA;
    private static final String NAME_LABEL = Messages._UI_LABEL_NAME;
    private static final String SELECT_FROM_WORKSPACE = Messages._UI_LABEL_WORKSPACE;
    private static final String SELECT_FROM_CATALOG = Messages._UI_LABEL_CATALOG;
    private String dialogTitle = Messages._UI_LABEL_ADD_CATEGORY;
    protected MenuManager browseMenu;
    protected Label name;
    protected Text nameText;
    protected Label schema;
    protected CLabel schemaDisplayer;
    protected ToolBar browseToolBar;
    protected ToolItem browseItem;
    protected Button searchCatalog;
    protected Button searchWorkspace;
    protected Composite sourcesComposite;
    protected List invalidNames;
    protected String appInfoSchemaLocation;
    protected String categoryName;
    protected CLabel errDisplayer;
    protected boolean isCategoryNameValid;
    protected boolean fromCatalog;
    private boolean canOK = false;
    protected String source;

    public AddNewCategoryDialog(Shell parentShell) {
        super(parentShell);
    }

    public AddNewCategoryDialog(Shell parentShell, String dialogTitle) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
    }

    public void setUnavailableCategoryNames(List unavailNames) {
        this.invalidNames = unavailNames;
    }

    public String getNewCategoryName() {
        return this.categoryName.trim();
    }

    public String getCategoryLocation() {
        return this.appInfoSchemaLocation;
    }

    public void setCategoryLocation(String s) {
        this.appInfoSchemaLocation = s;
    }

    public SpecificationForExtensionsSchema getExtensionsSchemaSpec() {
        SpecificationForExtensionsSchema schemaSpec = new SpecificationForExtensionsSchema();
        schemaSpec.setDisplayName(this.getNewCategoryName());
        schemaSpec.setLocation(this.getCategoryLocation());
        return schemaSpec;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public boolean getFromCatalog() {
        return this.fromCatalog;
    }

    public void setFromCatalog(boolean b) {
        this.fromCatalog = b;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.canOK);
        return result;
    }

    protected Button getButton(int id) {
        return super.getButton(id);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.dialogTitle);
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 10;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)new GridData(1808));
        GridData data = new GridData();
        data.widthHint = 400;
        mainComposite.setLayoutData((Object)data);
        this.name = new Label(mainComposite, 0);
        this.name.setText(NAME_LABEL);
        this.nameText = new Text(mainComposite, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        if (this.categoryName != null) {
            this.nameText.setText(this.categoryName);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.nameText, "org.eclipse.wst.xsd.ui.xsdud0190");
        this.schema = new Label(mainComposite, 0);
        this.schema.setText(SCHEMA_LABEL);
        this.schemaDisplayer = new CLabel(mainComposite, 2052);
        this.schemaDisplayer.setLayoutData((Object)new GridData(768));
        if (this.source != null) {
            if (this.fromCatalog) {
                this.schemaDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/xmlcatalog_obj.gif"));
            } else {
                this.schemaDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/XSDFile.gif"));
            }
            this.schemaDisplayer.setText(this.source);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.schemaDisplayer, "org.eclipse.wst.xsd.ui.xsdud0200");
        if (this.categoryName != null && this.source != null) {
            this.canOK = true;
        }
        Button hidden = new Button(mainComposite, 0);
        hidden.setVisible(false);
        this.sourcesComposite = new Composite(mainComposite, 0);
        RowLayout sourcesLayout = new RowLayout();
        this.sourcesComposite.setLayoutData((Object)new GridData(128));
        this.sourcesComposite.setLayout((Layout)sourcesLayout);
        this.searchWorkspace = new Button(this.sourcesComposite, 0);
        this.searchWorkspace.setText(SELECT_FROM_WORKSPACE);
        this.searchCatalog = new Button(this.sourcesComposite, 0);
        this.searchCatalog.setText(SELECT_FROM_CATALOG);
        this.searchWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile appInfoSchemaFile;
                SelectSingleFileDialog dialog = new SelectSingleFileDialog(AddNewCategoryDialog.this.getShell(), null, true);
                dialog.addFilterExtensions(new String[]{".xsd"});
                dialog.create();
                dialog.setTitle(Messages._UI_LABEL_SELECT_XSD_FILE);
                dialog.setMessage(Messages._UI_DESCRIPTION_CHOOSE_XSD_FILE);
                if (dialog.open() == 0 && (appInfoSchemaFile = dialog.getFile()) != null) {
                    String uri = appInfoSchemaFile.getFullPath().toString();
                    while (uri.startsWith("/") || uri.startsWith("\\")) {
                        uri = uri.substring(1);
                    }
                    AddNewCategoryDialog.this.appInfoSchemaLocation = uri.toString();
                    AddNewCategoryDialog.this.source = uri;
                    AddNewCategoryDialog.this.fromCatalog = false;
                    AddNewCategoryDialog.this.appInfoSchemaLocation = "file://" + Platform.getLocation().toString() + "/" + AddNewCategoryDialog.this.appInfoSchemaLocation;
                    AddNewCategoryDialog.this.schemaDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/XSDFile.gif"));
                    AddNewCategoryDialog.this.schemaDisplayer.setText(uri);
                    if (AddNewCategoryDialog.this.isCategoryNameValid) {
                        AddNewCategoryDialog.this.getButton(0).setEnabled(true);
                        AddNewCategoryDialog.this.errDisplayer.setText("");
                        AddNewCategoryDialog.this.errDisplayer.setImage(null);
                    }
                }
            }
        });
        this.searchCatalog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectFromCatalogDialog dialog = new SelectFromCatalogDialog(AddNewCategoryDialog.this.getShell());
                if (dialog.open() == 0) {
                    AddNewCategoryDialog.this.appInfoSchemaLocation = dialog.getCurrentSelectionLocation();
                    AddNewCategoryDialog.this.source = dialog.getCurrentSelectionNamespace();
                    AddNewCategoryDialog.this.fromCatalog = true;
                    AddNewCategoryDialog.this.schemaDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/xmlcatalog_obj.gif"));
                    AddNewCategoryDialog.this.schemaDisplayer.setText(dialog.getCurrentSelectionNamespace());
                    if (AddNewCategoryDialog.this.isCategoryNameValid && !AddNewCategoryDialog.this.appInfoSchemaLocation.equals("")) {
                        AddNewCategoryDialog.this.getButton(0).setEnabled(true);
                        AddNewCategoryDialog.this.errDisplayer.setText("");
                        AddNewCategoryDialog.this.errDisplayer.setImage(null);
                    }
                }
            }
        });
        this.errDisplayer = new CLabel(mainComposite, 0x800000);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.errDisplayer.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddNewCategoryDialog.this.categoryName = AddNewCategoryDialog.this.nameText.getText();
                if (AddNewCategoryDialog.this.invalidNames != null && AddNewCategoryDialog.this.invalidNames.contains(AddNewCategoryDialog.this.categoryName.trim())) {
                    AddNewCategoryDialog.this.isCategoryNameValid = false;
                    AddNewCategoryDialog.this.getButton(0).setEnabled(false);
                    AddNewCategoryDialog.this.errDisplayer.setText(Messages._UI_ERROR_NAME_ALREADY_USED);
                    AddNewCategoryDialog.this.errDisplayer.setImage(XSDEditorPlugin.getXSDImage("icons/error_st_obj.gif"));
                    return;
                }
                if (AddNewCategoryDialog.this.categoryName.equals("")) {
                    AddNewCategoryDialog.this.isCategoryNameValid = false;
                    AddNewCategoryDialog.this.getButton(0).setEnabled(false);
                    AddNewCategoryDialog.this.errDisplayer.setText("");
                    AddNewCategoryDialog.this.errDisplayer.setImage(null);
                    return;
                }
                if (!AddNewCategoryDialog.this.categoryName.equals("")) {
                    AddNewCategoryDialog.this.isCategoryNameValid = true;
                    AddNewCategoryDialog.this.errDisplayer.setText("");
                    AddNewCategoryDialog.this.errDisplayer.setImage(null);
                }
                if (AddNewCategoryDialog.this.appInfoSchemaLocation != null && !AddNewCategoryDialog.this.appInfoSchemaLocation.equals("")) {
                    AddNewCategoryDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
    }
}

