/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeEditorProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeFilter;

public class NodeCustomizationRegistry {
    private static final String NAMESPACE = "namespace";
    private static final String LABEL_PROVIDER_CLASS_ATTRIBUTE_NAME = "labelProviderClass";
    private static final String NODE_EDITOR_PROVIDER_CLASS_ATTRIBUTE_NAME = "nodeEditorProviderClass";
    private static final String FILTER_CLASS_ATTRIBUTE_NAME = "filterClass";
    protected String extensionId = "org.eclipse.wst.xsd.ui.extensibilityNodeCustomizations";
    protected HashMap map;

    public NodeCustomizationRegistry(String propertyEditorExtensionId) {
    }

    private HashMap initMap() {
        HashMap<String, Descriptor> theMap = new HashMap<String, Descriptor>();
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.xsd.ui.extensibilityNodeCustomizations");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement configurationElement = extensions[i];
            String namespace = configurationElement.getAttribute(NAMESPACE);
            if (namespace != null) {
                theMap.put(namespace, new Descriptor(configurationElement));
            }
            ++i;
        }
        return theMap;
    }

    private Descriptor getDescriptor(String namespace) {
        this.map = null;
        if (namespace != null) {
            if (this.map == null) {
                this.map = this.initMap();
            }
            return (Descriptor)this.map.get(namespace);
        }
        return null;
    }

    public NodeEditorProvider getNodeEditorProvider(String namespace) {
        Descriptor descriptor = this.getDescriptor(namespace);
        if (descriptor != null) {
            return descriptor.lookupOrCreateNodeEditorProvider();
        }
        return null;
    }

    public ILabelProvider getLabelProvider(String namespace) {
        Descriptor descriptor = this.getDescriptor(namespace);
        if (descriptor != null) {
            return descriptor.createLabelProvider();
        }
        return null;
    }

    public NodeFilter getNodeFilter(String namespace) {
        Descriptor descriptor = this.getDescriptor(namespace);
        if (descriptor != null) {
            return descriptor.getNodeFilter();
        }
        return null;
    }

    private class Descriptor {
        IConfigurationElement configurationElement;
        NodeEditorProvider nodeEditorProvider;
        NodeFilter nodeFilter;
        boolean nodeEditorProviderFailedToLoad = false;
        boolean labelProviderFailedToLoad = false;

        Descriptor(IConfigurationElement element) {
            this.configurationElement = element;
        }

        NodeEditorProvider lookupOrCreateNodeEditorProvider() {
            if (this.nodeEditorProvider == null && !this.nodeEditorProviderFailedToLoad) {
                try {
                    this.nodeEditorProvider = (NodeEditorProvider)this.configurationElement.createExecutableExtension(NodeCustomizationRegistry.NODE_EDITOR_PROVIDER_CLASS_ATTRIBUTE_NAME);
                }
                catch (Exception exception) {
                    this.nodeEditorProviderFailedToLoad = true;
                }
            }
            return this.nodeEditorProvider;
        }

        ILabelProvider createLabelProvider() {
            if (!this.labelProviderFailedToLoad) {
                try {
                    return (ILabelProvider)this.configurationElement.createExecutableExtension(NodeCustomizationRegistry.LABEL_PROVIDER_CLASS_ATTRIBUTE_NAME);
                }
                catch (Exception exception) {
                    this.labelProviderFailedToLoad = true;
                }
            }
            return null;
        }

        public NodeFilter getNodeFilter() {
            if (!this.nodeEditorProviderFailedToLoad) {
                try {
                    this.nodeFilter = (NodeFilter)this.configurationElement.createExecutableExtension(NodeCustomizationRegistry.FILTER_CLASS_ATTRIBUTE_NAME);
                }
                catch (Exception exception) {
                    this.nodeEditorProviderFailedToLoad = true;
                }
            }
            return this.nodeFilter;
        }
    }
}

