/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.builder.Messages;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.generator.IDerivedResourceMarkers;

public class DerivedResourceCleanerJob
extends Job {
    public static final Object DERIVED_RESOURCE_CLEANER_JOB_FAMILY = new Object();
    @Inject
    private IDerivedResourceMarkers derivedResourceMarkers;
    private IProject projectToClean;
    private String folderNameToClean;

    public DerivedResourceCleanerJob() {
        super(Messages.DerivedResourceCleanerJob_JOB_NAME);
    }

    public boolean belongsTo(Object family) {
        return family == DERIVED_RESOURCE_CLEANER_JOB_FAMILY;
    }

    public void initialize(IProject projectToClean, String folderNameToClean) {
        this.projectToClean = projectToClean;
        this.folderNameToClean = folderNameToClean;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    if (DerivedResourceCleanerJob.this.projectToClean == null) {
                        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            IStatus status = DerivedResourceCleanerJob.this.cleanUpDerivedResources(monitor, project);
                            if (status != Status.OK_STATUS) {
                                throw new CoreException(status);
                            }
                            ++n2;
                        }
                    } else {
                        IStatus status = DerivedResourceCleanerJob.this.cleanUpDerivedResources(monitor, DerivedResourceCleanerJob.this.projectToClean);
                        if (status != Status.OK_STATUS) {
                            throw new CoreException(status);
                        }
                    }
                }
            }.run(monitor);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                return ((CoreException)e.getTargetException()).getStatus();
            }
            Activator.log(e);
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected IStatus cleanUpDerivedResources(IProgressMonitor monitor, IProject project) throws CoreException, OperationCanceledException {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.shouldBeProcessed(project)) {
            IProject container = project;
            if (this.folderNameToClean != null) {
                container = container.getFolder((IPath)new Path(this.folderNameToClean));
            }
            for (IFile derivedFile : this.derivedResourceMarkers.findDerivedResources((IContainer)container, null)) {
                derivedFile.delete(true, monitor);
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    protected void deleteEmptyParent(IProgressMonitor monitor, IContainer container) throws CoreException {
        IContainer parent = container.getParent();
        if (container.members().length == 0) {
            container.delete(true, monitor);
            this.deleteEmptyParent(monitor, parent);
        }
    }

    protected boolean shouldBeProcessed(IProject project) {
        return XtextProjectHelper.hasNature((IProject)project) && XtextProjectHelper.hasBuilder((IProject)project) && (this.folderNameToClean == null || project.getFolder(this.folderNameToClean).exists());
    }
}

