/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.inject.Inject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.ResourceForIEditorInputFactory;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;

public class JavaClassPathResourceForIEditorInputFactory
extends ResourceForIEditorInputFactory {
    @Inject
    private IStorage2UriMapper storageToUriMapper;

    public IStorage2UriMapper getStorageToUriMapper() {
        return this.storageToUriMapper;
    }

    @Override
    protected Resource createResource(IStorage storage) throws CoreException {
        if (storage instanceof IJarEntryResource) {
            Resource result = this.createResourceFor((IJarEntryResource)storage);
            if (result == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.xtext.ui", "Cannot create resource for storage with path " + String.valueOf(storage.getFullPath())));
            }
            return result;
        }
        return super.createResource(storage);
    }

    protected Resource createResourceFor(IJarEntryResource storage) {
        ResourceSet resourceSet = this.getResourceSet((IStorage)storage);
        URI uri = this.storageToUriMapper.getUri((IStorage)storage);
        if (uri == null) {
            return null;
        }
        this.configureResourceSet(resourceSet, uri);
        XtextResource resource = this.createResource(resourceSet, uri);
        resource.setValidationDisabled(this.isValidationDisabled(uri, (IStorage)storage));
        return resource;
    }

    @Override
    protected boolean isValidationDisabled(URI uri, IStorage storage) {
        if (storage instanceof IJarEntryResource) {
            return true;
        }
        return super.isValidationDisabled(uri, storage);
    }

    @Override
    protected boolean isValidationDisabled(IStorage storage) {
        return this.isValidationDisabled(null, storage);
    }

    @Override
    protected ResourceSet getResourceSet(IStorage storage) {
        IJavaProject project;
        IPackageFragmentRoot root;
        if (storage instanceof IJarEntryResource && (root = ((IJarEntryResource)storage).getPackageFragmentRoot()) != null && (project = root.getJavaProject()) != null) {
            return this.getResourceSetProvider().get(project.getProject());
        }
        return super.getResourceSet(storage);
    }
}

