/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.occurrences;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.occurrences.IOccurrenceComputer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DefaultOccurrenceComputer
implements IOccurrenceComputer {
    private static Logger LOG = Logger.getLogger(DefaultOccurrenceComputer.class);
    public static final String OCCURRENCE_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.defaultOccurrenceAnnotation";
    public static final String DECLARATION_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.declarationAnnotation";
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private Provider<TargetURIs> targetURIsProvider;
    @Inject
    private TargetURICollector uriCollector;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    protected void addOccurrenceAnnotation(String type, IDocument document, ITextRegion textRegion, Map<Annotation, Position> annotationMap) {
        try {
            if (textRegion != null && textRegion.getLength() > 0) {
                Annotation annotation = new Annotation(type, false, document.get(textRegion.getOffset(), textRegion.getLength()));
                annotationMap.put(annotation, new Position(textRegion.getOffset(), textRegion.getLength()));
            }
        }
        catch (BadLocationException e) {
            LOG.error((Object)"Error creating occurrence annotation", (Throwable)e);
        }
    }

    @Override
    public Map<Annotation, Position> createAnnotationMap(XtextEditor editor, final ITextSelection selection, final SubMonitor monitor) {
        final IXtextDocument document = editor.getDocument();
        if (document != null) {
            return (Map)document.tryReadOnly((IUnitOfWork)new CancelableUnitOfWork<Map<Annotation, Position>, XtextResource>(){

                public Map<Annotation, Position> exec(XtextResource resource, final CancelIndicator cancelIndicator) throws Exception {
                    EObject target = DefaultOccurrenceComputer.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset());
                    if (target != null && !target.eIsProxy()) {
                        final ArrayList references = Lists.newArrayList();
                        IReferenceFinder.Acceptor acceptor = new IReferenceFinder.Acceptor(){

                            public void accept(IReferenceDescription reference) {
                                throw new UnsupportedOperationException("Local references are announced per object");
                            }

                            public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
                                EObjectReferenceAndIndex acceptMe = new EObjectReferenceAndIndex();
                                acceptMe.source = source;
                                acceptMe.reference = eReference;
                                acceptMe.idx = index;
                                references.add(acceptMe);
                            }
                        };
                        TargetURIs targetURIs = DefaultOccurrenceComputer.this.getTargetURIs(target);
                        if (!(targetURIs instanceof TargetURIs)) {
                            TargetURIs result = (TargetURIs)DefaultOccurrenceComputer.this.targetURIsProvider.get();
                            result.addAllURIs(targetURIs);
                            targetURIs = result;
                        }
                        NullProgressMonitor localMonitor = new NullProgressMonitor(){

                            public boolean isCanceled() {
                                return monitor.isCanceled() || cancelIndicator.isCanceled();
                            }
                        };
                        DefaultOccurrenceComputer.this.referenceFinder.findReferences((Predicate)targetURIs, (Resource)resource, acceptor, (IProgressMonitor)localMonitor);
                        DefaultOccurrenceComputer.this.operationCanceledManager.checkCanceled(cancelIndicator);
                        HashMap result = Maps.newHashMapWithExpectedSize((int)(references.size() + 1));
                        if (target.eResource() == resource && (!references.isEmpty() || DefaultOccurrenceComputer.this.canBeReferencedLocally(target))) {
                            ITextRegion declarationRegion = DefaultOccurrenceComputer.this.locationInFileProvider.getSignificantTextRegion(target);
                            DefaultOccurrenceComputer.this.addOccurrenceAnnotation(DefaultOccurrenceComputer.DECLARATION_ANNOTATION_TYPE, document, declarationRegion, result);
                        }
                        for (EObjectReferenceAndIndex highlightMe : references) {
                            try {
                                if (localMonitor.isCanceled()) {
                                    return Collections.emptyMap();
                                }
                                ITextRegion textRegion = DefaultOccurrenceComputer.this.locationInFileProvider.getSignificantTextRegion(highlightMe.source, (EStructuralFeature)highlightMe.reference, highlightMe.idx);
                                DefaultOccurrenceComputer.this.addOccurrenceAnnotation(DefaultOccurrenceComputer.OCCURRENCE_ANNOTATION_TYPE, document, textRegion, result);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return result;
                    }
                    return Collections.emptyMap();
                }
            }, () -> Collections.emptyMap());
        }
        return Collections.emptyMap();
    }

    protected Iterable<URI> getTargetURIs(EObject primaryTarget) {
        TargetURIs result = (TargetURIs)this.targetURIsProvider.get();
        this.uriCollector.add(primaryTarget, result);
        return result;
    }

    protected boolean canBeReferencedLocally(EObject object) {
        boolean result = this.qualifiedNameProvider.getFullyQualifiedName(object) != null;
        return result;
    }

    @Override
    public boolean hasAnnotationType(String annotationType) {
        return DECLARATION_ANNOTATION_TYPE.equals(annotationType) || OCCURRENCE_ANNOTATION_TYPE.equals(annotationType);
    }

    private static class EObjectReferenceAndIndex {
        EObject source;
        EReference reference;
        int idx;

        private EObjectReferenceAndIndex() {
        }
    }
}

