/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class ViewFreezer {
    protected ISourceViewer sourceViewer;
    protected Image image = null;
    protected Label label = null;

    public ViewFreezer(ISourceViewer viewer) {
        this.sourceViewer = viewer;
    }

    public void freeze() {
        Control viewerControl;
        this.release();
        if (this.sourceViewer instanceof SourceViewer && (viewerControl = ((SourceViewer)this.sourceViewer).getControl()) instanceof Composite) {
            Point size;
            Composite composite = (Composite)viewerControl;
            Display display = composite.getDisplay();
            while (!display.isDisposed() && display.readAndDispatch()) {
            }
            GC gc = new GC((Drawable)composite);
            try {
                size = composite.getSize();
                this.image = new Image(gc.getDevice(), size.x, size.y);
                gc.copyArea(this.image, 0, 0);
            }
            finally {
                gc.dispose();
                gc = null;
            }
            this.label = new Label(composite, 0);
            this.label.setImage(this.image);
            this.label.setBounds(0, 0, size.x, size.y);
            this.label.moveAbove(null);
        }
    }

    public void release() {
        if (this.label != null) {
            this.label.dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }
}

