/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.collection.GroupDescription;
import org.eclipse.xwt.collection.SortDescription;

public class CollectionViewSource {
    private Object source;
    private IObservableCollection view;
    private GroupDescription[] groupDescription = GroupDescription.EMPTY_ARRAY;
    private SortDescription[] sortDescription = SortDescription.EMPTY_ARRAY;
    private Locale locale = Locale.getDefault();
    private Class<?> collectionViewType = Object.class;

    public Object getSource() {
        if (this.source == null) {
            this.source = new ArrayList();
        }
        return this.source;
    }

    public void setSource(Object source) {
        if (this.source == source) {
            return;
        }
        this.view = null;
        this.source = source;
    }

    public IObservableCollection getView() {
        List<Object> source;
        if (this.view == null && !((source = this.getSource()) instanceof IObservableCollection)) {
            Class<?> elementType = this.getCollectionViewType();
            if (source.getClass().isArray()) {
                Object[] array = (Object[])source;
                elementType = source.getClass().getComponentType();
                source = Arrays.asList(array);
            }
            if (source instanceof List) {
                this.view = new WritableList(XWT.getRealm(), (List)source, elementType);
            } else if (source instanceof Set) {
                this.view = new WritableSet(XWT.getRealm(), source, elementType);
            }
        }
        return this.view;
    }

    public GroupDescription[] getGroupDescription() {
        return this.groupDescription;
    }

    public void setGroupDescription(GroupDescription[] groupDescription) {
        this.groupDescription = groupDescription;
    }

    public SortDescription[] getSortDescription() {
        return this.sortDescription;
    }

    public void setSortDescription(SortDescription[] sortDescription) {
        this.sortDescription = sortDescription;
    }

    public Class<?> getCollectionViewType() {
        return this.collectionViewType;
    }

    public void setCollectionViewType(Class<?> collectionViewType) {
        this.collectionViewType = collectionViewType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

