/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.core;

import java.util.HashMap;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.core.SetterBase;
import org.eclipse.xwt.core.TriggerAction;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.internal.utils.UserData;

public abstract class TriggerBase {
    public static final TriggerBase[] EMPTY_ARRAY = new TriggerBase[0];
    protected TriggerAction[] entryActions;
    protected TriggerAction[] exitActions;

    public TriggerAction[] getEntryActions() {
        if (this.entryActions == null) {
            return TriggerAction.EMPTY_ARRAY;
        }
        return this.entryActions;
    }

    public void setEntryActions(TriggerAction[] entryActions) {
        this.entryActions = entryActions;
    }

    public TriggerAction[] getExitActions() {
        if (this.exitActions == null) {
            return TriggerAction.EMPTY_ARRAY;
        }
        return this.exitActions;
    }

    public void setExitActions(TriggerAction[] exitActions) {
        this.exitActions = exitActions;
    }

    public abstract void on(Object var1);

    public abstract void prepare(Object var1);

    public static Object getElementByName(Object target, String elementName) {
        Widget widget;
        if (elementName != null && elementName.length() > 0 && (widget = UserData.getWidget(target)) != null) {
            Object element = XWT.findElementByName(widget, elementName);
            if (element != null) {
                return element;
            }
            LoggerManager.log("EventTrigger: Source \n" + elementName + "\n is not found in " + target.getClass().getName());
        }
        return target;
    }

    abstract class AbstractChangeListener
    implements IChangeListener {
        protected HashMap<SetterBase, Object> oldvalues = null;
        protected Object element;

        public AbstractChangeListener(Object element) {
            this.element = element;
        }

        protected void restoreValues() {
            if (this.oldvalues == null) {
                return;
            }
            for (SetterBase setter : this.oldvalues.keySet()) {
                setter.undo(this.element, this.oldvalues.get(setter));
            }
        }
    }
}

