/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Event;
import org.eclipse.xwt.IObservableValueListener;
import org.eclipse.xwt.databinding.XWTObservableValue;
import org.eclipse.xwt.internal.core.IEventController;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.internal.utils.ObservableValueManager;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.javabean.metadata.properties.EventProperty;
import org.eclipse.xwt.metadata.IEvent;

public class EventPropertyObservableValue
extends XWTObservableValue {
    private EventProperty property;

    public EventPropertyObservableValue(Object observed, EventProperty property) {
        super(Boolean.class, observed, property.getName());
        this.property = property;
        IEventController controller = UserData.findEventController(observed);
        if (controller == null) {
            controller = UserData.updateEventController(observed);
        }
        IEvent event = property.getEvent();
        IObservableValueListener manager = UserData.getObservableValueManager(observed);
        if (manager == null) {
            manager = new ObservableValueManager(observed);
            UserData.setObservableValueManager(observed, manager);
        }
        try {
            controller.setEvent(event, UserData.getWidget(observed), manager, property, IObservableValueListener.class.getDeclaredMethod("changeValueHandle", Object.class, Event.class));
            manager.registerValue(property, (IObservableValue)this);
        }
        catch (Exception e) {
            LoggerManager.log(e);
            return;
        }
    }

    @Override
    protected void doSetApprovedValue(Object value) {
        UserData.setLocalData(this.getObserved(), this.property.getName(), value);
    }

    @Override
    protected Object doGetValue() {
        return UserData.getLocalData(this.getObserved(), this.property.getName());
    }
}

