/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.dataproviders;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.core.IBinding;
import org.eclipse.xwt.databinding.JFaceXWTDataBinding;
import org.eclipse.xwt.dataproviders.AbstractDataProvider;
import org.eclipse.xwt.dataproviders.IObjectDataProvider;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;

public class ObjectDataProvider
extends AbstractDataProvider
implements IObjectDataProvider {
    static IDataProvider.DataModelService dataModelService = new IDataProvider.DataModelService(){

        @Override
        public Object toModelType(Object object) {
            return JFaceXWTDataBinding.toType(object);
        }

        @Override
        public Object loadModelType(String className) {
            return XWT.getLoadingContext().loadClass(className);
        }

        @Override
        public Object toModelPropertyType(Object type, String propertyName) {
            IMetaclass metaclass = XWT.getMetaclass(type);
            IProperty property = metaclass.findProperty(propertyName);
            if (property == null) {
                throw new XWTException(" Property \"" + propertyName + "\" is not found in the class " + metaclass.getType().getName());
            }
            return property.getType();
        }
    };
    private Object objectInstance;
    private Class<?> objectType;
    private String methodName;
    private List<Object> methodParameters;

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public List<Object> getMethodParameters() {
        return this.methodParameters;
    }

    @Override
    public Object getObjectInstance() {
        if (this.objectInstance == null && this.objectType != null) {
            try {
                this.objectInstance = this.objectType.newInstance();
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        return this.objectInstance;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.objectType == null && this.objectInstance != null) {
            this.objectType = this.objectInstance.getClass();
        }
        return this.objectType;
    }

    @Override
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void setMethodParameters(List<Object> parameters) {
        this.methodParameters = parameters;
    }

    @Override
    public void setObjectInstance(Object objectImstance) {
        this.objectInstance = objectImstance;
    }

    @Override
    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    protected Object getTarget() {
        Object target = this.getObjectInstance();
        if (target == null) {
            return null;
        }
        Class<?> targetType = this.getObjectType();
        Method method = null;
        if (this.methodName != null) {
            ArrayList paras = new ArrayList();
            if (this.methodParameters != null) {
                for (Object p : this.methodParameters) {
                    paras.add(p.getClass());
                }
            }
            try {
                if (paras.isEmpty()) {
                    method = targetType.getDeclaredMethod(this.methodName, new Class[0]);
                    return method.invoke(target, new Object[0]);
                }
                method = targetType.getDeclaredMethod(this.methodName, paras.toArray(new Class[paras.size()]));
                return method.invoke(target, this.methodParameters.toArray(new Object[this.methodParameters.size()]));
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return target;
    }

    @Override
    public Object getData(String path) {
        if (path == null) {
            return this.getTarget();
        }
        return this.getData(this.getTarget(), path);
    }

    @Override
    public Object getData(Object object, String path) {
        if (object instanceof IObservableValue) {
            object = ((IObservableValue)object).getValue();
        }
        if (path == null || path.trim().length() == 0 || path.equals(".")) {
            return JFaceXWTDataBinding.getValue(object, null);
        }
        int index = path.indexOf(".");
        while (index != -1 && object != null) {
            object = JFaceXWTDataBinding.getValue(object, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        return JFaceXWTDataBinding.getValue(object, path);
    }

    @Override
    public void setData(Object object, String path, Object value) {
        if (object instanceof IObservableValue) {
            object = ((IObservableValue)object).getValue();
        }
        int index = path.indexOf(".");
        while (index != -1 && object != null) {
            object = JFaceXWTDataBinding.getValue(object, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        JFaceXWTDataBinding.setValue(object, path, value);
    }

    @Override
    public void setData(String path, Object value) {
        this.setData(this.getTarget(), path, value);
    }

    @Override
    public Class<?> getDataType(String path) {
        Object target = this.getTarget();
        if (target == null) {
            return null;
        }
        Class<?> type = JFaceXWTDataBinding.toType(target);
        if (path == null) {
            return type;
        }
        return JFaceXWTDataBinding.getValueType(type, path);
    }

    @Override
    public boolean isPropertyReadOnly(String path) {
        Object target = this.getTarget();
        if (target == null || path == null) {
            return true;
        }
        if (target instanceof IBinding) {
            target = ((IBinding)target).getValue(null);
        }
        Class<?> type = JFaceXWTDataBinding.toType(target);
        int index = path.indexOf(".");
        while (index != -1 && target != null) {
            type = JFaceXWTDataBinding.getValueType(type, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        return JFaceXWTDataBinding.isPropertyReadOnly(type, path);
    }

    @Override
    protected IObservableValue observeValue(Object bean, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            return BeanProperties.value(bean.getClass(), (String)propertyName).observe(XWT.getRealm(), bean);
        }
        return PojoProperties.value(bean.getClass(), (String)propertyName).observe(XWT.getRealm(), bean);
    }

    @Override
    protected IObservableList observeList(Object bean, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            IBeanListProperty list = BeanProperties.list(bean.getClass(), (String)propertyName, null);
            IObservableList res = list.observe(XWT.getRealm(), bean);
            return res;
        }
        return PojoProperties.list(bean.getClass(), (String)propertyName, null).observe(XWT.getRealm(), bean);
    }

    @Override
    protected IObservableSet observeSet(Object bean, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            return BeanProperties.set(bean.getClass(), (String)propertyName, null).observe(XWT.getRealm(), bean);
        }
        return PojoProperties.set(bean.getClass(), (String)propertyName, null).observe(XWT.getRealm(), bean);
    }

    @Override
    protected IObservableList observeDetailList(IObservableValue bean, Object elementType, String propertyName, Object propertyType) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            Class beanClass = null;
            if (bean.getValueType() instanceof Class) {
                beanClass = (Class)bean.getValueType();
            }
            return BeanProperties.list((Class)beanClass, (String)propertyName, (Class)((Class)propertyType)).observeDetail(bean);
        }
        Class pojoClass = null;
        if (bean.getValueType() instanceof Class) {
            pojoClass = (Class)bean.getValueType();
        }
        return PojoProperties.list(pojoClass, (String)propertyName).observeDetail(bean);
    }

    @Override
    protected IObservableSet observeDetailSet(IObservableValue bean, Object elementType, String propertyName, Object propertyType) {
        if (JFaceXWTDataBinding.isBeanSupport(bean)) {
            Class beanClass = null;
            if (bean.getValueType() instanceof Class) {
                beanClass = (Class)bean.getValueType();
            }
            return BeanProperties.set((Class)beanClass, (String)propertyName, (Class)((Class)propertyType)).observeDetail(bean);
        }
        Class pojoClass = null;
        if (bean.getValueType() instanceof Class) {
            pojoClass = (Class)bean.getValueType();
        }
        return PojoProperties.set((Class)pojoClass, (String)propertyName, (Class)((Class)propertyType)).observeDetail(bean);
    }

    @Override
    protected IObservableValue observeDetailValue(IObservableValue master, Object elementType, String propertyName, Object propertyType) {
        Class beanClass = (Class)elementType;
        if (beanClass == null && master.getValueType() instanceof Class) {
            beanClass = (Class)master.getValueType();
        }
        if (JFaceXWTDataBinding.isBeanSupport(beanClass)) {
            return BeanProperties.value((Class)beanClass, (String)propertyName, (Class)((Class)propertyType)).observeDetail(master);
        }
        return PojoProperties.value((Class)beanClass, (String)propertyName, (Class)((Class)propertyType)).observeDetail(master);
    }

    @Override
    public IValueProperty createValueProperty(Object type, String propertyName) {
        if (JFaceXWTDataBinding.isBeanSupport(type)) {
            return BeanProperties.value(JFaceXWTDataBinding.toType(type), (String)propertyName);
        }
        return PojoProperties.value(JFaceXWTDataBinding.toType(type), (String)propertyName);
    }

    @Override
    public IDataProvider.DataModelService getModelService() {
        return dataModelService;
    }
}

