/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelEntityFactory
extends AbstractStylingModelFactory {
    AbstractStructuredGraphViewer viewer = null;

    public GraphModelEntityFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    @Override
    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    @Override
    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object inputElement = this.getViewer().getInput();
        Object[] entities = this.getContentProvider().getElements(inputElement);
        if (entities == null) {
            return;
        }
        Object[] objectArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Object data = objectArray[n2];
            IFigureProvider figureProvider = null;
            if (this.getLabelProvider() instanceof IFigureProvider) {
                figureProvider = (IFigureProvider)this.getLabelProvider();
            }
            if (!this.filterElement(inputElement, data)) {
                if (figureProvider != null) {
                    this.createNode(model, data, figureProvider.getFigure(data));
                } else {
                    this.createNode(model, data);
                }
            }
            ++n2;
        }
        Set<Object> keySet = ((AbstractStructuredGraphViewer)this.getViewer()).getNodesMap().keySet();
        Object[] objectArray2 = entities = keySet.toArray();
        int n3 = entities.length;
        n = 0;
        while (n < n3) {
            Object[] related;
            Object data = objectArray2[n];
            if (!this.filterElement(inputElement, data) && (related = ((IGraphEntityContentProvider)this.getContentProvider()).getConnectedTo(data)) != null) {
                Object[] objectArray3 = related;
                int n4 = related.length;
                int n5 = 0;
                while (n5 < n4) {
                    EntityConnectionData connectionData;
                    Object element = objectArray3[n5];
                    if (!this.filterElement(inputElement, element) && !this.filterElement(inputElement, connectionData = new EntityConnectionData(data, element))) {
                        this.createConnection(model, connectionData, data, element);
                    }
                    ++n5;
                }
            }
            ++n;
        }
    }

    @Override
    public void refresh(Graph graph, Object element, boolean refreshLabels) {
        GraphConnection graphConnection;
        if (element == null) {
            return;
        }
        GraphNode node = this.viewer.getGraphModelNode(element);
        if (node == null && (graphConnection = this.viewer.getGraphModelConnection(element)) != null) {
            this.refresh(graph, graphConnection.getSource().getData(), refreshLabels);
            this.refresh(graph, graphConnection.getDestination().getData(), refreshLabels);
            return;
        }
        if (node == null) {
            return;
        }
        this.reconnect(graph, element, refreshLabels);
        if (refreshLabels) {
            this.update(node);
            for (GraphItem graphItem : node.getSourceConnections()) {
                this.update(graphItem);
            }
            for (GraphItem graphItem : node.getTargetConnections()) {
                this.update(graphItem);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reconnect(Graph graph, Object element, boolean refreshLabels) {
        void var13_14;
        GraphNode node = this.viewer.getGraphModelNode(element);
        Object[] related = ((IGraphEntityContentProvider)this.getContentProvider()).getConnectedTo(element);
        List<? extends GraphConnection> connections = node.getSourceConnections();
        LinkedList toAdd = new LinkedList();
        LinkedList toDelete = new LinkedList();
        LinkedList toKeep = new LinkedList();
        HashSet<Object> oldExternalConnections = new HashSet<Object>();
        HashSet<EntityConnectionData> newExternalConnections = new HashSet<EntityConnectionData>();
        for (GraphConnection graphConnection : connections) {
            oldExternalConnections.add(graphConnection.getExternalConnection());
        }
        Object[] objectArray = related;
        int n = related.length;
        boolean n2 = false;
        while (var13_14 < n) {
            Object object = objectArray[var13_14];
            newExternalConnections.add(new EntityConnectionData(element, object));
            ++var13_14;
        }
        for (Object e : oldExternalConnections) {
            if (!newExternalConnections.contains(e)) {
                toDelete.add(e);
                continue;
            }
            toKeep.add(e);
        }
        for (Object e : newExternalConnections) {
            if (oldExternalConnections.contains(e)) continue;
            toAdd.add(e);
        }
        for (Object e : toDelete) {
            this.viewer.removeGraphModelConnection(e);
        }
        toDelete.clear();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object e : toAdd) {
            EntityConnectionData data = (EntityConnectionData)e;
            GraphNode dest = this.viewer.getGraphModelNode(data.dest);
            if (dest == null) {
                linkedList.add(data.dest);
            }
            this.createConnection(graph, data, data.source, data.dest);
        }
        toAdd.clear();
        if (refreshLabels) {
            for (Object e : toKeep) {
                this.styleItem(this.viewer.getGraphModelConnection(e));
            }
        }
        for (Object e : linkedList) {
            this.refresh(graph, e);
        }
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }
}

