/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Ipam;
import org.mandas.docker.client.messages.NetworkConfig;

final class ImmutableNetworkConfig
implements NetworkConfig {
    private final String name;
    @Nullable
    private final String driver;
    @Nullable
    private final Ipam ipam;
    private final Map<String, String> options;
    @Nullable
    private final Boolean checkDuplicate;
    @Nullable
    private final Boolean internal;
    @Nullable
    private final Boolean enableIPv6;
    @Nullable
    private final Boolean attachable;
    @Nullable
    private final Map<String, String> labels;

    private ImmutableNetworkConfig(String name, @Nullable String driver, @Nullable Ipam ipam, Map<String, String> options, @Nullable Boolean checkDuplicate, @Nullable Boolean internal, @Nullable Boolean enableIPv6, @Nullable Boolean attachable, @Nullable Map<String, String> labels) {
        this.name = name;
        this.driver = driver;
        this.ipam = ipam;
        this.options = options;
        this.checkDuplicate = checkDuplicate;
        this.internal = internal;
        this.enableIPv6 = enableIPv6;
        this.attachable = attachable;
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Driver")
    @Nullable
    public String driver() {
        return this.driver;
    }

    @Override
    @JsonProperty(value="IPAM")
    @Nullable
    public Ipam ipam() {
        return this.ipam;
    }

    @Override
    @JsonProperty(value="Options")
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    @JsonProperty(value="CheckDuplicate")
    @Nullable
    public Boolean checkDuplicate() {
        return this.checkDuplicate;
    }

    @Override
    @JsonProperty(value="Internal")
    @Nullable
    public Boolean internal() {
        return this.internal;
    }

    @Override
    @JsonProperty(value="EnableIPv6")
    @Nullable
    public Boolean enableIPv6() {
        return this.enableIPv6;
    }

    @Override
    @JsonProperty(value="Attachable")
    @Nullable
    public Boolean attachable() {
        return this.attachable;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    public final ImmutableNetworkConfig withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkConfig(newValue, this.driver, this.ipam, this.options, this.checkDuplicate, this.internal, this.enableIPv6, this.attachable, this.labels);
    }

    public final ImmutableNetworkConfig withDriver(@Nullable String value) {
        if (Objects.equals(this.driver, value)) {
            return this;
        }
        return new ImmutableNetworkConfig(this.name, value, this.ipam, this.options, this.checkDuplicate, this.internal, this.enableIPv6, this.attachable, this.labels);
    }

    public final ImmutableNetworkConfig withIpam(@Nullable Ipam value) {
        if (this.ipam == value) {
            return this;
        }
        return new ImmutableNetworkConfig(this.name, this.driver, value, this.options, this.checkDuplicate, this.internal, this.enableIPv6, this.attachable, this.labels);
    }

    public final ImmutableNetworkConfig withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableNetworkConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetworkConfig(this.name, this.driver, this.ipam, newValue, this.checkDuplicate, this.internal, this.enableIPv6, this.attachable, this.labels);
    }

    public final ImmutableNetworkConfig withCheckDuplicate(@Nullable Boolean value) {
        if (Objects.equals(this.checkDuplicate, value)) {
            return this;
        }
        return new ImmutableNetworkConfig(this.name, this.driver, this.ipam, this.options, value, this.internal, this.enableIPv6, this.attachable, this.labels);
    }

    public final ImmutableNetworkConfig withInternal(@Nullable Boolean value) {
        if (Objects.equals(this.internal, value)) {
            return this;
        }
        return new ImmutableNetworkConfig(this.name, this.driver, this.ipam, this.options, this.checkDuplicate, value, this.enableIPv6, this.attachable, this.labels);
    }

    public final ImmutableNetworkConfig withEnableIPv6(@Nullable Boolean value) {
        if (Objects.equals(this.enableIPv6, value)) {
            return this;
        }
        return new ImmutableNetworkConfig(this.name, this.driver, this.ipam, this.options, this.checkDuplicate, this.internal, value, this.attachable, this.labels);
    }

    public final ImmutableNetworkConfig withAttachable(@Nullable Boolean value) {
        if (Objects.equals(this.attachable, value)) {
            return this;
        }
        return new ImmutableNetworkConfig(this.name, this.driver, this.ipam, this.options, this.checkDuplicate, this.internal, this.enableIPv6, value, this.labels);
    }

    public final ImmutableNetworkConfig withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableNetworkConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetworkConfig(this.name, this.driver, this.ipam, this.options, this.checkDuplicate, this.internal, this.enableIPv6, this.attachable, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkConfig && this.equalTo(0, (ImmutableNetworkConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableNetworkConfig another) {
        return this.name.equals(another.name) && Objects.equals(this.driver, another.driver) && Objects.equals(this.ipam, another.ipam) && this.options.equals(another.options) && Objects.equals(this.checkDuplicate, another.checkDuplicate) && Objects.equals(this.internal, another.internal) && Objects.equals(this.enableIPv6, another.enableIPv6) && Objects.equals(this.attachable, another.attachable) && Objects.equals(this.labels, another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.driver);
        h += (h << 5) + Objects.hashCode(this.ipam);
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + Objects.hashCode(this.checkDuplicate);
        h += (h << 5) + Objects.hashCode(this.internal);
        h += (h << 5) + Objects.hashCode(this.enableIPv6);
        h += (h << 5) + Objects.hashCode(this.attachable);
        h += (h << 5) + Objects.hashCode(this.labels);
        return h;
    }

    public String toString() {
        return "NetworkConfig{name=" + this.name + ", driver=" + this.driver + ", ipam=" + this.ipam + ", options=" + this.options + ", checkDuplicate=" + this.checkDuplicate + ", internal=" + this.internal + ", enableIPv6=" + this.enableIPv6 + ", attachable=" + this.attachable + ", labels=" + this.labels + "}";
    }

    public static ImmutableNetworkConfig copyOf(NetworkConfig instance) {
        if (instance instanceof ImmutableNetworkConfig) {
            return (ImmutableNetworkConfig)instance;
        }
        return ImmutableNetworkConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements NetworkConfig.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String driver;
        private Ipam ipam;
        private Map<String, String> options = new LinkedHashMap<String, String>();
        private Boolean checkDuplicate;
        private Boolean internal;
        private Boolean enableIPv6;
        private Boolean attachable;
        private Map<String, String> labels = null;

        private Builder() {
        }

        public final Builder from(NetworkConfig instance) {
            Map<String, String> labelsValue;
            Boolean attachableValue;
            Boolean enableIPv6Value;
            Boolean internalValue;
            Ipam ipamValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            String driverValue = instance.driver();
            if (driverValue != null) {
                this.driver(driverValue);
            }
            if ((ipamValue = instance.ipam()) != null) {
                this.ipam(ipamValue);
            }
            this.putAllOptions(instance.options());
            Boolean checkDuplicateValue = instance.checkDuplicate();
            if (checkDuplicateValue != null) {
                this.checkDuplicate(checkDuplicateValue);
            }
            if ((internalValue = instance.internal()) != null) {
                this.internal(internalValue);
            }
            if ((enableIPv6Value = instance.enableIPv6()) != null) {
                this.enableIPv6(enableIPv6Value);
            }
            if ((attachableValue = instance.attachable()) != null) {
                this.attachable(attachableValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Driver")
        public final Builder driver(@Nullable String driver) {
            this.driver = driver;
            return this;
        }

        @Override
        @JsonProperty(value="IPAM")
        public final Builder ipam(@Nullable Ipam ipam) {
            this.ipam = ipam;
            return this;
        }

        @Override
        public final Builder addOption(String key, String value) {
            this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
            return this;
        }

        public final Builder addOption(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "options value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Options")
        public final Builder options(Map<String, ? extends String> entries) {
            this.options.clear();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "options value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="CheckDuplicate")
        public final Builder checkDuplicate(@Nullable Boolean checkDuplicate) {
            this.checkDuplicate = checkDuplicate;
            return this;
        }

        @Override
        @JsonProperty(value="Internal")
        public final Builder internal(@Nullable Boolean internal) {
            this.internal = internal;
            return this;
        }

        @Override
        @JsonProperty(value="EnableIPv6")
        public final Builder enableIPv6(@Nullable Boolean enableIPv6) {
            this.enableIPv6 = enableIPv6;
            return this;
        }

        @Override
        @JsonProperty(value="Attachable")
        public final Builder attachable(@Nullable Boolean attachable) {
            this.attachable = attachable;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @Override
        public ImmutableNetworkConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkConfig(this.name, this.driver, this.ipam, ImmutableNetworkConfig.createUnmodifiableMap(false, false, this.options), this.checkDuplicate, this.internal, this.enableIPv6, this.attachable, this.labels == null ? null : ImmutableNetworkConfig.createUnmodifiableMap(false, false, this.labels));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build NetworkConfig, some of required attributes are not set " + attributes;
        }
    }
}

