/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.ConfigBind;
import org.mandas.docker.client.messages.swarm.ConfigFile;

final class ImmutableConfigBind
implements ConfigBind {
    private final ConfigFile file;
    private final String configId;
    private final String configName;

    private ImmutableConfigBind(ConfigFile file, String configId, String configName) {
        this.file = file;
        this.configId = configId;
        this.configName = configName;
    }

    @Override
    @JsonProperty(value="File")
    public ConfigFile file() {
        return this.file;
    }

    @Override
    @JsonProperty(value="ConfigID")
    public String configId() {
        return this.configId;
    }

    @Override
    @JsonProperty(value="ConfigName")
    public String configName() {
        return this.configName;
    }

    public final ImmutableConfigBind withFile(ConfigFile value) {
        if (this.file == value) {
            return this;
        }
        ConfigFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableConfigBind(newValue, this.configId, this.configName);
    }

    public final ImmutableConfigBind withConfigId(String value) {
        String newValue = Objects.requireNonNull(value, "configId");
        if (this.configId.equals(newValue)) {
            return this;
        }
        return new ImmutableConfigBind(this.file, newValue, this.configName);
    }

    public final ImmutableConfigBind withConfigName(String value) {
        String newValue = Objects.requireNonNull(value, "configName");
        if (this.configName.equals(newValue)) {
            return this;
        }
        return new ImmutableConfigBind(this.file, this.configId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfigBind && this.equalTo(0, (ImmutableConfigBind)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfigBind another) {
        return this.file.equals(another.file) && this.configId.equals(another.configId) && this.configName.equals(another.configName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + this.configId.hashCode();
        h += (h << 5) + this.configName.hashCode();
        return h;
    }

    public String toString() {
        return "ConfigBind{file=" + this.file + ", configId=" + this.configId + ", configName=" + this.configName + "}";
    }

    public static ImmutableConfigBind copyOf(ConfigBind instance) {
        if (instance instanceof ImmutableConfigBind) {
            return (ImmutableConfigBind)instance;
        }
        return ImmutableConfigBind.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ConfigBind.Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_CONFIG_ID = 2L;
        private static final long INIT_BIT_CONFIG_NAME = 4L;
        private long initBits = 7L;
        private ConfigFile file;
        private String configId;
        private String configName;

        private Builder() {
        }

        public final Builder from(ConfigBind instance) {
            Objects.requireNonNull(instance, "instance");
            this.file(instance.file());
            this.configId(instance.configId());
            this.configName(instance.configName());
            return this;
        }

        @Override
        @JsonProperty(value="File")
        public final Builder file(ConfigFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="ConfigID")
        public final Builder configId(String configId) {
            this.configId = Objects.requireNonNull(configId, "configId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="ConfigName")
        public final Builder configName(String configName) {
            this.configName = Objects.requireNonNull(configName, "configName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableConfigBind build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfigBind(this.file, this.configId, this.configName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("configId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("configName");
            }
            return "Cannot build ConfigBind, some of required attributes are not set " + attributes;
        }
    }
}

