/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core;

import java.util.Date;
import org.eclipse.mylyn.reviews.core.model.review.Rating;
import org.eclipse.mylyn.tasks.core.ITask;

public class ReviewSubTask {
    private String comment;
    private ITask task;
    private Date creationDate;
    private String patchFile;
    private String author;
    private String reviewer;
    private Rating result;

    public ReviewSubTask(String patchFile, Date creationDate, String author, String reviewer, Rating result, String comment, ITask task) {
        this.patchFile = patchFile;
        this.creationDate = new Date(creationDate.getTime());
        this.author = author;
        this.reviewer = reviewer;
        this.result = result;
        this.comment = comment;
        this.task = task;
    }

    public String getPatchFile() {
        return this.patchFile;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getPatchDescription() {
        return String.format("%s %s", this.patchFile, this.creationDate);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public Rating getResult() {
        return this.result;
    }

    public String getComment() {
        return this.comment;
    }

    public ITask getTask() {
        return this.task;
    }

    public String toString() {
        return "Review Subtask " + this.patchFile + " by " + this.author + " revd by " + this.reviewer + " rated as " + (Object)((Object)this.result);
    }
}

