/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.adapter;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.rmf.tests.serialization.model.nodes.Node;
import org.eclipse.rmf.tests.serialization.model.nodes.NodesFactory;
import org.eclipse.rmf.tests.serialization.model.nodes.NodesPackage;
import org.eclipse.rmf.tests.serialization.model.nodes.serialization.NodesResourceFactoryImpl;
import org.eclipse.rmf.tests.serialization.model.nodes.serialization.NodesResourceImpl;
import org.eclipse.rmf.tests.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IDAdapterTests
extends AbstractTestCase {
    static final String INPUT_PATH = "org.eclipse.rmf.tests.serialization.adapter/";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/serialization/model/nodes.ecore", (Object)NodesPackage.eINSTANCE);
    }

    @Test
    public void testIdOnLoad() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.adapter/minimal.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new NodesResourceFactoryImpl(), null);
            Assert.assertTrue((boolean)(modelRoot instanceof Node));
            Node rootNode = (Node)modelRoot;
            Assert.assertTrue((boolean)rootNode.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testIdOnLoadNotModified() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.adapter/minimalWithId.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new NodesResourceFactoryImpl(), null);
            Assert.assertTrue((boolean)(modelRoot instanceof Node));
            Node rootNode = (Node)modelRoot;
            Assert.assertEquals((Object)"root", (Object)rootNode.getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testIdForNewObjectsAfterLoad1() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.adapter/minimal.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new NodesResourceFactoryImpl(), null);
            Assert.assertTrue((boolean)(modelRoot instanceof Node));
            Node rootNode = (Node)modelRoot;
            Assert.assertTrue((boolean)rootNode.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertSame((Object)1, (Object)((XMLResource)modelRoot.eResource()).getEObjectToIDMap().size());
            Node subNode = NodesFactory.eINSTANCE.createNode();
            rootNode.setEReference_Contained0100Single(subNode);
            Assert.assertTrue((boolean)subNode.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertSame((Object)2, (Object)((XMLResource)modelRoot.eResource()).getEObjectToIDMap().size());
            rootNode.getEReference_Contained1100Many().add((Object)NodesFactory.eINSTANCE.createNode());
            Assert.assertTrue((5 < ((Node)rootNode.getEReference_Contained1100Many().get(0)).getName().length() ? 1 : 0) != 0);
            Assert.assertSame((Object)3, (Object)((XMLResource)modelRoot.eResource()).getEObjectToIDMap().size());
            ArrayList<Node> newNodes = new ArrayList<Node>();
            int i = 0;
            while (i < 5) {
                newNodes.add(NodesFactory.eINSTANCE.createNode());
                ++i;
            }
            rootNode.getEReference_Contained0100Many().addAll(newNodes);
            i = 0;
            while (i < 5) {
                Assert.assertTrue((5 < ((Node)rootNode.getEReference_Contained0100Many().get(i)).getName().length() ? 1 : 0) != 0);
                ++i;
            }
            Assert.assertSame((Object)8, (Object)((XMLResource)modelRoot.eResource()).getEObjectToIDMap().size());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testIdForNewObjectsAfterLoad2() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.adapter/minimal.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new NodesResourceFactoryImpl(), null);
            Assert.assertTrue((boolean)(modelRoot instanceof Node));
            Node rootNode = (Node)modelRoot;
            Assert.assertTrue((boolean)rootNode.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertSame((Object)1, (Object)((XMLResource)modelRoot.eResource()).getEObjectToIDMap().size());
            Node sub1Node = NodesFactory.eINSTANCE.createNode();
            Node sub2Node = NodesFactory.eINSTANCE.createNode();
            Node sub3Node = NodesFactory.eINSTANCE.createNode();
            Node sub4Node = NodesFactory.eINSTANCE.createNode();
            sub4Node.setName("sub4Node");
            sub1Node.setEReference_Contained0101Single(sub2Node);
            sub2Node.setEReference_Contained0101Single(sub3Node);
            sub3Node.setEReference_Contained0101Single(sub4Node);
            Assert.assertFalse((boolean)sub1Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertFalse((boolean)sub2Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertFalse((boolean)sub3Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertTrue((boolean)sub4Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertEquals((Object)"sub4Node", (Object)sub4Node.getName());
            Assert.assertSame((Object)1, (Object)((XMLResource)modelRoot.eResource()).getEObjectToIDMap().size());
            rootNode.setEReference_Contained0100Single(sub1Node);
            Assert.assertTrue((boolean)sub1Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertTrue((boolean)sub2Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertTrue((boolean)sub3Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertTrue((boolean)sub4Node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
            Assert.assertEquals((Object)"sub4Node", (Object)sub4Node.getName());
            Assert.assertSame((Object)5, (Object)((XMLResource)modelRoot.eResource()).getEObjectToIDMap().size());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testAddNewElementToEmptyResource() {
        NodesResourceImpl resource = new NodesResourceImpl();
        Node node = NodesFactory.eINSTANCE.createNode();
        Node subNode = NodesFactory.eINSTANCE.createNode();
        node.getEReference_Contained0100Many().add((Object)subNode);
        Assert.assertFalse((boolean)node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
        Assert.assertFalse((boolean)subNode.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
        resource.getContents().add((Object)node);
        Assert.assertTrue((boolean)node.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
        Assert.assertTrue((boolean)subNode.eIsSet((EStructuralFeature)NodesPackage.eINSTANCE.getNode_Name()));
    }

    @Test
    public void testIdMapSet() {
        NodesResourceImpl resource = new NodesResourceImpl();
        String nodeName = "root";
        String subNodeName = "subNode";
        Node node = NodesFactory.eINSTANCE.createNode();
        node.setName(nodeName);
        Node subNode = NodesFactory.eINSTANCE.createNode();
        subNode.setName(subNodeName);
        node.setEReference_Contained0100Single(subNode);
        Assert.assertNull((Object)resource.getEObject(nodeName));
        Assert.assertNull((Object)resource.getID(node));
        Assert.assertNull((Object)resource.getEObject(subNodeName));
        Assert.assertNull((Object)resource.getID(subNode));
        resource.getContents().add((Object)node);
        Assert.assertSame((Object)node, (Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)nodeName, (Object)resource.getID(node));
        Assert.assertSame((Object)subNode, (Object)resource.getEObject(subNodeName));
        Assert.assertSame((Object)subNodeName, (Object)resource.getID(subNode));
    }

    @Test
    public void testIdMapAdd() {
        NodesResourceImpl resource = new NodesResourceImpl();
        String nodeName = "root";
        String subNodeName = "subNode";
        Node node = NodesFactory.eINSTANCE.createNode();
        node.setName(nodeName);
        Node subNode = NodesFactory.eINSTANCE.createNode();
        subNode.setName(subNodeName);
        node.getEReference_Contained0100Many().add((Object)subNode);
        Assert.assertNull((Object)resource.getEObject(nodeName));
        Assert.assertNull((Object)resource.getID(node));
        Assert.assertNull((Object)resource.getEObject(subNodeName));
        Assert.assertNull((Object)resource.getID(subNode));
        resource.getContents().add((Object)node);
        Assert.assertSame((Object)node, (Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)nodeName, (Object)resource.getID(node));
        Assert.assertSame((Object)subNode, (Object)resource.getEObject(subNodeName));
        Assert.assertSame((Object)subNodeName, (Object)resource.getID(subNode));
    }

    @Test
    public void testIdMapAddMany() {
        NodesResourceImpl resource = new NodesResourceImpl();
        String node1Name = "node1";
        String node2Name = "node2";
        Node node1 = NodesFactory.eINSTANCE.createNode();
        node1.setName(node1Name);
        Node node2 = NodesFactory.eINSTANCE.createNode();
        node2.setName(node2Name);
        ArrayList<Node> nodes = new ArrayList<Node>(2);
        nodes.add(node1);
        nodes.add(node2);
        Assert.assertNull((Object)resource.getEObject(node1Name));
        Assert.assertNull((Object)resource.getID(node1));
        Assert.assertNull((Object)resource.getEObject(node2Name));
        Assert.assertNull((Object)resource.getID(node2));
        resource.getContents().addAll(nodes);
        Assert.assertSame((Object)node1, (Object)resource.getEObject(node1Name));
        Assert.assertSame((Object)node1Name, (Object)resource.getID(node1));
        Assert.assertSame((Object)node2, (Object)resource.getEObject(node2Name));
        Assert.assertSame((Object)node2Name, (Object)resource.getID(node2));
    }

    @Test
    public void testIdMapMove() {
        NodesResourceImpl resource = new NodesResourceImpl();
        String nodeName = "root";
        String subNodeName = "subNode";
        Node node = NodesFactory.eINSTANCE.createNode();
        node.setName(nodeName);
        Node subNode = NodesFactory.eINSTANCE.createNode();
        subNode.setName(subNodeName);
        node.getEReference_Contained0100Many().add((Object)subNode);
        Assert.assertNull((Object)resource.getEObject(nodeName));
        Assert.assertNull((Object)resource.getID(node));
        Assert.assertNull((Object)resource.getEObject(subNodeName));
        Assert.assertNull((Object)resource.getID(subNode));
        resource.getContents().add((Object)node);
        Assert.assertSame((Object)node, (Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)nodeName, (Object)resource.getID(node));
        Assert.assertSame((Object)subNode, (Object)resource.getEObject(subNodeName));
        Assert.assertSame((Object)subNodeName, (Object)resource.getID(subNode));
        node.setEReference_Contained0100Single(subNode);
        Assert.assertSame((Object)node, (Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)nodeName, (Object)resource.getID(node));
        Assert.assertSame((Object)subNode, (Object)resource.getEObject(subNodeName));
        Assert.assertSame((Object)subNodeName, (Object)resource.getID(subNode));
    }

    @Test
    public void testIdMapRemove() {
        NodesResourceImpl resource = new NodesResourceImpl();
        String nodeName = "root";
        String subNodeName = "subNode";
        Node node = NodesFactory.eINSTANCE.createNode();
        node.setName(nodeName);
        Node subNode = NodesFactory.eINSTANCE.createNode();
        subNode.setName(subNodeName);
        node.getEReference_Contained0100Many().add((Object)subNode);
        Assert.assertNull((Object)resource.getEObject(nodeName));
        Assert.assertNull((Object)resource.getID(node));
        Assert.assertNull((Object)resource.getEObject(subNodeName));
        Assert.assertNull((Object)resource.getID(subNode));
        resource.getContents().add((Object)node);
        Assert.assertSame((Object)node, (Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)nodeName, (Object)resource.getID(node));
        Assert.assertSame((Object)subNode, (Object)resource.getEObject(subNodeName));
        Assert.assertSame((Object)subNodeName, (Object)resource.getID(subNode));
        node.getEReference_Contained0100Many().remove((Object)subNode);
        Assert.assertSame((Object)node, (Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)nodeName, (Object)resource.getID(node));
        Assert.assertNull((Object)resource.getEObject(subNodeName));
        Assert.assertNull((Object)resource.getID(subNode));
        resource.getContents().remove((Object)node);
        Assert.assertNull((Object)resource.getEObject(nodeName));
        Assert.assertNull((Object)resource.getID(node));
        Assert.assertNull((Object)resource.getEObject(subNodeName));
        Assert.assertNull((Object)resource.getID(subNode));
    }

    @Test
    public void testIdMapRename() {
        NodesResourceImpl resource = new NodesResourceImpl();
        String nodeName = "root";
        String newNodeName = "new_root";
        Node node = NodesFactory.eINSTANCE.createNode();
        node.setName(nodeName);
        Assert.assertNull((Object)resource.getEObject(nodeName));
        Assert.assertNull((Object)resource.getID(node));
        resource.getContents().add((Object)node);
        Assert.assertNull((Object)resource.getEObject(newNodeName));
        Assert.assertSame((Object)node, (Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)nodeName, (Object)resource.getID(node));
        node.setName(newNodeName);
        Assert.assertNull((Object)resource.getEObject(nodeName));
        Assert.assertSame((Object)node, (Object)resource.getEObject(newNodeName));
        Assert.assertSame((Object)newNodeName, (Object)resource.getID(node));
    }
}

