/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.Comparator;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.IContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnSortComparator
implements Comparator<Integer> {
    public static final int SORT_NONE = -1;
    public static final int SORT_UP = 1;
    public static final int SORT_DOWN = 2;
    private int colIndex = Integer.MIN_VALUE;
    private int direction = -1;
    private AgileGrid agileGrid;

    public ColumnSortComparator(AgileGrid agileGrid, int columnIndex, int direction) {
        this.agileGrid = agileGrid;
        this.setSortDirection(direction);
        this.setColumnToCompare(columnIndex);
    }

    @Override
    public final int compare(Integer i1, Integer i2) {
        int row1 = i1;
        int row2 = i2;
        if (this.direction == -1) {
            if (row1 > row2) {
                return 1;
            }
            if (row1 < row2) {
                return -1;
            }
            return 0;
        }
        IContentProvider contentProvider = this.agileGrid.getContentProvider();
        Object content1 = contentProvider.getContentAt(row1, this.colIndex);
        Object content2 = contentProvider.getContentAt(row2, this.colIndex);
        if (this.direction == 2) {
            return -this.doCompare(content1, content2, row1, row2);
        }
        return this.doCompare(content1, content2, row1, row2);
    }

    public abstract int doCompare(Object var1, Object var2, int var3, int var4);

    public void setColumnToCompare(int column) {
        this.colIndex = column;
    }

    public int getSortDirection() {
        return this.direction;
    }

    public void setSortDirection(int direction) {
        if (direction != 1 && direction != 2 && direction != -1) {
            throw new IllegalArgumentException("Undefined sorting direction: " + direction);
        }
        this.direction = direction;
    }

    public int getColumnToSortOn() {
        return this.colIndex;
    }
}

