/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class Logging {
    private static final Logger LOG = Logger.getLogger(Logging.class.getName());
    public static final String AGILEGRID_LOGGING_PROPERTY = "org.peertoo.agilegrid.Logging";
    private static final Level DEFAULT_LOGGING_LEVEL;
    public static final Level MIN_SHOW_LEVEL;
    public static final boolean SHOW_FINEST;
    public static final boolean SHOW_FINER;
    public static final boolean SHOW_FINE;
    public static final boolean SHOW_CONFIG;
    public static final boolean SHOW_INFO;
    public static final boolean SHOW_WARNING;
    public static final boolean SHOW_SEVERE;

    static {
        Level setLevel = DEFAULT_LOGGING_LEVEL = Level.FINEST;
        try {
            String propertyLevel = System.getProperty(AGILEGRID_LOGGING_PROPERTY);
            if (propertyLevel != null) {
                setLevel = Level.parse(propertyLevel);
            }
        }
        catch (SecurityException disallowed) {
            LOG.log(Level.WARNING, "Could not read configuration property.", disallowed);
        }
        SHOW_FINEST = (MIN_SHOW_LEVEL = setLevel).intValue() <= Level.FINEST.intValue();
        SHOW_FINER = MIN_SHOW_LEVEL.intValue() <= Level.FINER.intValue();
        SHOW_FINE = MIN_SHOW_LEVEL.intValue() <= Level.FINE.intValue();
        SHOW_CONFIG = MIN_SHOW_LEVEL.intValue() <= Level.CONFIG.intValue();
        SHOW_INFO = MIN_SHOW_LEVEL.intValue() <= Level.INFO.intValue();
        SHOW_WARNING = MIN_SHOW_LEVEL.intValue() <= Level.WARNING.intValue();
        boolean bl = SHOW_SEVERE = MIN_SHOW_LEVEL.intValue() <= Level.SEVERE.intValue();
        if (SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            LOG.config("Logging enabled for level : " + MIN_SHOW_LEVEL);
        }
    }

    private Logging() {
    }
}

