/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.agilemore.agilegrid.SWTResourceManager;
import org.agilemore.agilegrid.renderers.HeaderCellRenderer;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.UnifiedColumn;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrAgileGridContentProvider;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

class ProrHeaderCellRenderer
extends HeaderCellRenderer {
    public static Color COLOR_REQIF_ATTRIBUTE = SWTResourceManager.getColor((int)9);
    public static Color COLOR_UNIFIED = SWTResourceManager.getColor((int)14);

    public ProrHeaderCellRenderer(AgileGrid agileGrid) {
        super(agileGrid, 36);
        this.setAlignment(49);
    }

    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        ProrRow prorRow;
        ProrAgileGridContentProvider contentProvider = (ProrAgileGridContentProvider)this.agileGrid.getContentProvider();
        if (row >= 0 && !(prorRow = contentProvider.getProrRow(row)).isVisible()) {
            return;
        }
        String label = "";
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        if (row == -1 && col >= 0 && col < layoutAdvisor.getColumnCount()) {
            label = layoutAdvisor.getTopHeaderLabel(col);
        } else if (col == -1 && row >= 0 && row < layoutAdvisor.getRowCount()) {
            label = layoutAdvisor.getLeftHeaderLabel(row);
        } else if (row == -1 && col == -1) {
            label = "";
        }
        ProrSpecViewConfiguration specView = contentProvider.specViewConfig;
        if (col >= 0 && col < specView.getColumns().size() && specView.getColumns().get(col) instanceof UnifiedColumn) {
            gc.setForeground(COLOR_UNIFIED);
        } else if (label.startsWith("ReqIF.")) {
            label = label.substring(6);
            gc.setForeground(COLOR_REQIF_ATTRIBUTE);
        }
        int alignment = this.getAlignment();
        this.drawTextImage(gc, label, alignment, null, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
        this.drawSortIndicator(gc, rect, row, col, label);
    }
}

