/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.ListIterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.pror.editor.presentation.SetLastChangeCommand;

public class TimestampedCompoundCommand
extends CompoundCommand {
    private EditingDomain domain;

    public TimestampedCompoundCommand(EditingDomain domain, Command command) {
        super(Collections.singletonList(command));
        this.domain = domain;
    }

    public void execute() {
        System.out.println("Executing timestamp command");
        Calendar cal = Calendar.getInstance();
        Date lastChange = cal.getTime();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(lastChange);
        XMLGregorianCalendar date2 = null;
        try {
            date2 = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        HashSet lastChangeObjects = new HashSet();
        ArrayList arrList = Lists.newArrayList((Iterable)this.commandList);
        this.commandList = arrList;
        ListIterator<SetLastChangeCommand> commands = arrList.listIterator();
        while (commands.hasNext()) {
            try {
                Command command = (Command)commands.next();
                System.out.println("Executing " + command);
                command.execute();
                for (Object obj : command.getAffectedObjects()) {
                    System.out.println("Affected " + obj);
                    if (!(obj instanceof Identifiable) || !lastChangeObjects.add(obj)) continue;
                    System.out.println("Adding setLastChange");
                    SetLastChangeCommand setLastChangeCommand = new SetLastChangeCommand(this.domain, (EObject)((Identifiable)obj), date2);
                    commands.add(setLastChangeCommand);
                    int i = 0;
                    while (i < 2) {
                        if (commands.hasPrevious()) {
                            commands.previous();
                        }
                        ++i;
                    }
                }
                continue;
            }
            catch (RuntimeException exception) {
                commands.previous();
                try {
                    while (commands.hasPrevious()) {
                        Command command = (Command)commands.previous();
                        if (command.canUndo()) {
                            command.undo();
                        }
                    }
                }
                catch (RuntimeException nestedException) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)nestedException).fillInStackTrace());
                }
            }
            throw exception;
        }
    }
}

