/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.smack;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnectionObjectPacketEvent;
import org.eclipse.ecf.internal.provider.xmpp.smack.ECFConnectionPacketEvent;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IAsynchEventHandler;
import org.eclipse.ecf.provider.comm.IConnectionListener;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.ecf.provider.xmpp.identity.XMPPRoomID;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class ECFConnection
implements ISynchAsynchConnection {
    private static final String GOOGLE_TALK_HOST = "talk.google.com";
    public static final String CLIENT_TYPE = "ecf.";
    public static final boolean DEBUG = Boolean.getBoolean("smack.debug");
    protected static final String STRING_ENCODING = "UTF-8";
    public static final String OBJECT_PROPERTY_NAME = String.valueOf(ECFConnection.class.getName()) + ".object";
    protected static final int XMPP_DEFAULT_PORT = 5222;
    protected static final int XMPPS_DEFAULT_PORT = 5223;
    private XMPPConnection connection = null;
    private IAsynchEventHandler handler = null;
    private boolean isStarted = false;
    private int serverPort = -1;
    private String serverResource;
    private final Map properties = null;
    private boolean isConnected = false;
    private Namespace namespace = null;
    private boolean google = false;
    private boolean disconnecting = false;
    private int BIND_TIMEOUT = new Integer(System.getProperty("org.eclipse.ecf.provider.xmpp.ECFConnection.bindTimeout", "15000"));
    private Object bindLock = new Object();
    private String jid;
    private CallbackHandler callbackHandler;
    private final PacketListener packetListener = new PacketListener(){

        public void processPacket(Packet arg0) {
            ECFConnection.this.handlePacket(arg0);
        }
    };
    private final ConnectionListener connectionListener = new ConnectionListener(){

        public void connectionClosed() {
            ECFConnection.this.handleConnectionClosed(new IOException("Connection reset by peer"));
        }

        public void connectionClosedOnError(Exception e) {
            ECFConnection.this.handleConnectionClosed(e);
        }

        public void reconnectingIn(int seconds) {
        }

        public void reconnectionFailed(Exception e) {
        }

        public void reconnectionSuccessful() {
        }
    };

    protected void logException(String msg, Throwable t) {
        XmppPlugin.log(msg, t);
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public XMPPConnection getXMPPConnection() {
        return this.connection;
    }

    public ECFConnection(boolean google, Namespace ns, IAsynchEventHandler h) {
        this(google, ns, h, null);
    }

    public ECFConnection(boolean google, Namespace ns, IAsynchEventHandler h, CallbackHandler ch) {
        this.handler = h;
        this.namespace = ns;
        this.google = google;
        this.callbackHandler = ch;
        if (DEBUG) {
            XMPPConnection.DEBUG_ENABLED = true;
        }
    }

    protected String getPasswordForObject(Object data) {
        String password = null;
        try {
            password = (String)data;
        }
        catch (ClassCastException e) {
            return null;
        }
        return password;
    }

    private XMPPID getXMPPID(ID remote) throws ECFException {
        XMPPID jabberID = null;
        try {
            jabberID = (XMPPID)remote;
        }
        catch (ClassCastException e) {
            throw new ECFException((Throwable)e);
        }
        return jabberID;
    }

    public synchronized Object connect(ID remote, Object data, int timeout) throws ECFException {
        if (this.connection != null) {
            throw new ECFException("already connected");
        }
        if (timeout > 0) {
            SmackConfiguration.setPacketReplyTimeout((int)timeout);
        }
        Roster.setDefaultSubscriptionMode((Roster.SubscriptionMode)Roster.SubscriptionMode.manual);
        XMPPID jabberURI = this.getXMPPID(remote);
        String username = jabberURI.getNodename();
        String hostname = jabberURI.getHostname();
        String hostnameOverride = null;
        int semiColonIdx = hostname.lastIndexOf(59);
        if (semiColonIdx != -1) {
            hostnameOverride = hostname.substring(semiColonIdx + 1);
            hostname = hostname.substring(0, semiColonIdx);
        }
        if (this.google && hostnameOverride == null) {
            hostnameOverride = GOOGLE_TALK_HOST;
        }
        String serviceName = hostname;
        this.serverPort = jabberURI.getPort();
        this.serverResource = jabberURI.getResourceName();
        if (this.serverResource == null || this.serverResource.equals("/")) {
            this.serverResource = this.getClientIdentifier();
            jabberURI.setResourceName(this.serverResource);
        }
        try {
            ConnectionConfiguration config = hostnameOverride != null ? new ConnectionConfiguration(hostnameOverride, 5222, serviceName) : (this.serverPort == -1 ? new ConnectionConfiguration(serviceName) : new ConnectionConfiguration(serviceName, this.serverPort));
            config.setSendPresence(true);
            if (this.callbackHandler instanceof javax.security.auth.callback.CallbackHandler) {
                config.setCallbackHandler((javax.security.auth.callback.CallbackHandler)this.callbackHandler);
            }
            this.connection = new XMPPConnection(config);
            this.connection.connect();
            SASLAuthentication.supportSASLMechanism((String)"PLAIN", (int)0);
            if (this.google || GOOGLE_TALK_HOST.equals(hostnameOverride)) {
                username = String.valueOf(username) + "@" + serviceName;
            }
            this.connection.addPacketListener(this.packetListener, null);
            this.connection.addConnectionListener(this.connectionListener);
            this.connection.login(username, (String)data, this.serverResource);
            this.waitForBindResult();
        }
        catch (XMPPException e) {
            throw new ContainerConnectException("Login attempt failed", (Throwable)e);
        }
        return this.jid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForBindResult() throws XMPPException {
        long bindTimeout = System.currentTimeMillis() + (long)this.BIND_TIMEOUT;
        Object object = this.bindLock;
        synchronized (object) {
            while (true) {
                if (this.jid != null || System.currentTimeMillis() >= bindTimeout) {
                    if (this.jid != null) break;
                    throw new XMPPException("timeout waiting for server bind result");
                }
                try {
                    this.bindLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isConnected = true;
            return;
        }
    }

    private String getClientIdentifier() {
        return CLIENT_TYPE + this.handler.getEventHandlerID().getName();
    }

    public void sendPacket(Packet packet) throws XMPPException {
        if (this.connection != null) {
            this.connection.sendPacket(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        this.disconnecting = true;
        if (this.isStarted()) {
            this.stop();
        }
        if (this.connection != null) {
            this.connection.removePacketListener(this.packetListener);
            this.connection.removeConnectionListener(this.connectionListener);
            this.connection.disconnect();
            this.connection = null;
            Object object = this.bindLock;
            synchronized (object) {
                this.jid = null;
                this.isConnected = false;
            }
        }
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    public synchronized ID getLocalID() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return IDFactory.getDefault().createID(this.namespace.getName(), new Object[]{this.connection.getConnectionID()});
        }
        catch (Exception e) {
            this.logException("Exception in getLocalID", e);
            return null;
        }
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public synchronized void stop() {
        this.isStarted = false;
    }

    protected void handleConnectionClosed(Exception e) {
        if (!this.disconnecting) {
            this.disconnecting = true;
            this.handler.handleDisconnectEvent(new DisconnectEvent((IAsynchConnection)this, (Throwable)e, null));
        }
    }

    protected void handlePacket(Packet arg0) {
        this.handleJidPacket(arg0);
        try {
            Object val = arg0.getProperty(OBJECT_PROPERTY_NAME);
            if (val != null) {
                this.handler.handleAsynchEvent((AsynchEvent)new ECFConnectionObjectPacketEvent((IAsynchConnection)this, arg0, val));
            } else {
                this.handler.handleAsynchEvent((AsynchEvent)new ECFConnectionPacketEvent((IAsynchConnection)this, arg0));
            }
        }
        catch (IOException e) {
            this.logException("Exception in handleAsynchEvent", e);
            try {
                this.disconnect();
            }
            catch (Exception e1) {
                this.logException("Exception in disconnect()", e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJidPacket(Packet packet) {
        IQ iqPacket;
        if (this.jid != null) {
            return;
        }
        if (packet instanceof IQ && (iqPacket = (IQ)packet).getType().equals(IQ.Type.RESULT) && iqPacket instanceof Bind) {
            Bind bindPacket = (Bind)iqPacket;
            Object object = this.bindLock;
            synchronized (object) {
                this.jid = bindPacket.getJid();
                this.bindLock.notify();
            }
        }
    }

    public synchronized void sendAsynch(ID receiver, byte[] data) throws IOException {
        if (data == null) {
            throw new IOException("no data");
        }
        Message aMsg = new Message();
        aMsg.setProperty(OBJECT_PROPERTY_NAME, (Object)data);
        this.sendMessage(receiver, aMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(ID receiver, Message aMsg) throws IOException {
        ECFConnection eCFConnection = this;
        synchronized (eCFConnection) {
            block9: {
                if (!this.isConnected()) {
                    throw new IOException("not connected");
                }
                try {
                    if (receiver == null) {
                        throw new IOException("receiver cannot be null for xmpp instant messaging");
                    }
                    if (receiver instanceof XMPPID) {
                        XMPPID rcvr = (XMPPID)receiver;
                        aMsg.setType(Message.Type.chat);
                        String receiverName = rcvr.getFQName();
                        Chat localChat = this.connection.getChatManager().createChat(receiverName, new MessageListener(){

                            public void processMessage(Chat chat, Message message) {
                            }
                        });
                        localChat.sendMessage(aMsg);
                        break block9;
                    }
                    if (receiver instanceof XMPPRoomID) {
                        XMPPRoomID roomID = (XMPPRoomID)receiver;
                        aMsg.setType(Message.Type.groupchat);
                        String to = roomID.getMucString();
                        aMsg.setTo(to);
                        this.connection.sendPacket((Packet)aMsg);
                        break block9;
                    }
                    throw new IOException("receiver must be of type XMPPID or XMPPRoomID");
                }
                catch (XMPPException e) {
                    IOException result = new IOException("XMPPException in sendMessage: " + e.getMessage());
                    result.setStackTrace(e.getStackTrace());
                    throw result;
                }
            }
        }
    }

    public synchronized Object sendSynch(ID receiver, byte[] data) throws IOException {
        if (data == null) {
            throw new IOException("data cannot be null");
        }
        return null;
    }

    public void addListener(IConnectionListener listener) {
    }

    public void removeListener(IConnectionListener listener) {
    }

    public void sendMessage(ID target, String message) throws IOException {
        if (target == null) {
            throw new IOException("target cannot be null");
        }
        if (message == null) {
            throw new IOException("message cannot be null");
        }
        Message aMsg = new Message();
        aMsg.setBody(message);
        this.sendMessage(target, aMsg);
    }

    public static Map getPropertiesFromPacket(Packet packet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : packet.getPropertyNames()) {
            result.put(name, packet.getProperty(name));
        }
        return result;
    }

    public static Packet setPropertiesInPacket(Packet input, Map properties) {
        if (properties != null) {
            for (Object keyo : properties.keySet()) {
                Object val = properties.get(keyo);
                String key = keyo instanceof String ? (String)keyo : keyo.toString();
                input.setProperty(key, val);
            }
        }
        return input;
    }

    public void sendMessage(ID target, ID thread, Message.Type type, String subject, String body, Map properties2) throws IOException {
        if (target == null) {
            throw new IOException("XMPP target for message cannot be null");
        }
        if (body == null) {
            body = "";
        }
        Message aMsg = new Message();
        aMsg.setBody(body);
        if (thread != null) {
            aMsg.setThread(thread.getName());
        }
        if (type != null) {
            aMsg.setType(type);
        }
        if (subject != null) {
            aMsg.setSubject(subject);
        }
        ECFConnection.setPropertiesInPacket((Packet)aMsg, properties2);
        this.sendMessage(target, aMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPresenceUpdate(ID target, Presence presence) throws IOException {
        if (presence == null) {
            throw new IOException("presence cannot be null");
        }
        presence.setFrom(this.connection.getUser());
        if (target != null) {
            presence.setTo(target.getName());
        }
        ECFConnection eCFConnection = this;
        synchronized (eCFConnection) {
            if (!this.isConnected()) {
                throw new IOException("not connected");
            }
            this.connection.sendPacket((Packet)presence);
        }
    }

    public void sendRosterAdd(String user, String name, String[] groups) throws IOException, XMPPException {
        Roster r = this.getRoster();
        r.createEntry(user, name, groups);
    }

    public void sendRosterRemove(String user) throws XMPPException, IOException {
        Roster r = this.getRoster();
        RosterEntry re = r.getEntry(user);
        r.removeEntry(re);
    }

    public Roster getRoster() throws IOException {
        if (this.connection == null || !this.connection.isConnected()) {
            return null;
        }
        return this.connection.getRoster();
    }
}

