/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.presence;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.internal.example.collab.presence.PresenceContainer;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.IPresenceListener;
import org.eclipse.ecf.presence.IPresenceSender;
import org.eclipse.ecf.presence.roster.AbstractRosterManager;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionSender;
import org.eclipse.ecf.presence.roster.Roster;

public class RosterManager
extends AbstractRosterManager {
    private List presenceListeners = new LinkedList();
    private PresenceContainer presenceContainer;

    public RosterManager(PresenceContainer presenceContainer, IUser user) {
        this.presenceContainer = presenceContainer;
        this.roster = new Roster((IPresenceContainerAdapter)presenceContainer, user){

            public boolean addItem(IRosterItem item) {
                if (super.addItem(item)) {
                    RosterManager.this.fireRosterAdd((IRosterEntry)item);
                    return true;
                }
                return false;
            }

            public boolean removeItem(IRosterItem item) {
                if (super.removeItem(item)) {
                    RosterManager.this.fireRosterRemove((IRosterEntry)item);
                    return true;
                }
                return false;
            }
        };
    }

    public IPresenceSender getPresenceSender() {
        return this.presenceContainer;
    }

    public IRosterSubscriptionSender getRosterSubscriptionSender() {
        return null;
    }

    public void addPresenceListener(IPresenceListener listener) {
        if (!this.presenceListeners.contains(listener)) {
            this.presenceListeners.add(listener);
        }
    }

    public void removePresenceListener(IPresenceListener listener) {
        this.presenceListeners.remove(listener);
    }
}

