/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.provider.zookeeper.core.internal.Configuration;
import org.osgi.framework.ServiceReference;

public class Configurator
extends DiscoveryContainerConfig {
    private File zooConfFile;
    private File zookeeperData;
    private List<Configuration> runningConfigs = new ArrayList<Configuration>();
    public static final Configurator INSTANCE = new Configurator();
    private static final ID ConfigID = IDFactory.getDefault().createStringID(UUID.randomUUID().toString());

    private Configurator() {
        super(ConfigID);
    }

    public Configuration createConfig(ID targetId) {
        Assert.isNotNull((Object)targetId);
        Configuration conf = new Configuration(targetId);
        this.runningConfigs.add(conf);
        return conf;
    }

    public Configuration createConfig(ServiceReference reference) {
        Assert.isNotNull((Object)reference);
        Configuration conf = new Configuration(reference);
        this.runningConfigs.add(conf);
        return conf;
    }

    public Configuration createConfig(String propsAsString) {
        Assert.isNotNull((Object)propsAsString);
        Configuration conf = new Configuration(propsAsString);
        this.runningConfigs.add(conf);
        return conf;
    }

    public void cleanAll() {
        File[] fileArray = this.zookeeperData.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                if (file.isDirectory()) {
                    File[] fileArray2 = file.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray2[n4];
                        f.delete();
                        ++n4;
                    }
                }
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
    }

    public String getConfFile() {
        return this.zooConfFile.toString();
    }

    public static boolean isValid(String flavorInput) {
        Assert.isNotNull((Object)flavorInput);
        boolean valid = flavorInput.contains("=");
        String f = flavorInput.split("=")[0];
        return valid &= f.equals("zoodiscovery.flavor.centralized") || f.equals("zoodiscovery.flavor.replicated") || f.equals("zoodiscovery.flavor.standalone");
    }

    public static void validateFlavor(String f) {
        if (!Configurator.isValid(f)) {
            throw new IllegalArgumentException(f);
        }
    }

    public ID getID() {
        return ConfigID;
    }
}

