/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.util.HashMap;
import java.util.Random;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.sharedobject.SharedObjectContainerFactory;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;

public class ClientApplication {
    public static final int DEFAULT_WAITTIME = 40000;
    public static final int DEFAULT_TIMEOUT = TCPServerSOContainer.DEFAULT_KEEPALIVE;
    public static final String CONTAINER_FACTORY_NAME;
    public static final String CONTAINER_FACTORY_CLASS;
    public static final String COMPOSENT_CONTAINER_NAME;
    static int clientCount;
    ISharedObjectContainer[] sm = new ISharedObjectContainer[clientCount];
    String serverName = null;
    String[] sharedObjectClassNames = null;
    ID[] sharedObjects = null;
    static ContainerTypeDescription contd;
    static Random aRan;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.GenericContainerInstantiator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONTAINER_FACTORY_CLASS = CONTAINER_FACTORY_NAME = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.provider.generic.GenericContainerInstantiator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COMPOSENT_CONTAINER_NAME = clazz2.getName();
        clientCount = 1;
        contd = null;
        aRan = new Random();
    }

    public void init(String[] args) throws Exception {
        int i;
        this.serverName = TCPServerSOContainer.getDefaultServerURL();
        if (args.length > 0 && !args[0].equals("-")) {
            this.serverName = args[0];
        }
        if (args.length > 1) {
            this.sharedObjectClassNames = new String[args.length - 1];
            i = 0;
            while (i < args.length - 1) {
                this.sharedObjectClassNames[i] = args[i + 1];
                ++i;
            }
        }
        contd = new ContainerTypeDescription(CONTAINER_FACTORY_NAME, CONTAINER_FACTORY_CLASS, null);
        ContainerFactory.getDefault().addDescription(contd);
        i = 0;
        while (i < clientCount) {
            this.sm[i] = this.createClient();
            ++i;
        }
    }

    protected ISharedObjectContainer createClient() throws Exception {
        ID newContainerID = IDFactory.getDefault().createGUID();
        ISharedObjectContainer result = SharedObjectContainerFactory.getDefault().createSharedObjectContainer(contd, new Object[]{newContainerID, DEFAULT_TIMEOUT});
        return result;
    }

    public void connect(ID server) throws Exception {
        int i = 0;
        while (i < clientCount) {
            System.out.print("ClientApplication " + this.sm[i].getID().getName() + " joining " + server.getName() + "...");
            this.sm[i].connect(server, null);
            System.out.println("completed.");
            ++i;
        }
    }

    public void disconnect() {
        int i = 0;
        while (i < clientCount) {
            System.out.print("ClientApplication " + this.sm[i].getID().getName() + " leaving...");
            this.sm[i].disconnect();
            System.out.println("completed.");
            ++i;
        }
    }

    public void createSharedObjects() throws Exception {
        if (this.sharedObjectClassNames != null) {
            int j = 0;
            while (j < clientCount) {
                ISharedObjectContainer scg = this.sm[j];
                this.sharedObjects = new ID[this.sharedObjectClassNames.length];
                int i = 0;
                while (i < this.sharedObjectClassNames.length) {
                    System.out.println("Creating sharedObject: " + this.sharedObjectClassNames[i] + " for client " + scg.getID().getName());
                    ISharedObject so = (ISharedObject)Class.forName(this.sharedObjectClassNames[i]).newInstance();
                    this.sharedObjects[i] = IDFactory.getDefault().createStringID(String.valueOf(this.sharedObjectClassNames[i]) + "_" + i);
                    scg.getSharedObjectManager().addSharedObject(this.sharedObjects[i], so, new HashMap());
                    System.out.println("Created sharedObject for client " + scg.getID().getName());
                    ++i;
                }
                ++j;
            }
        }
    }

    public void removeSharedObjects() throws Exception {
        if (this.sharedObjects == null) {
            return;
        }
        int j = 0;
        while (j < clientCount) {
            int i = 0;
            while (i < this.sharedObjects.length) {
                System.out.println("Removing sharedObject: " + this.sharedObjects[i].getName() + " for client " + this.sm[j].getID().getName());
                this.sm[j].getSharedObjectManager().removeSharedObject(this.sharedObjects[i]);
                ++i;
            }
            ++j;
        }
    }

    public static void main(String[] args) throws Exception {
        ClientApplication st = new ClientApplication();
        st.init(args);
        ID serverID = IDFactory.getDefault().createStringID(st.serverName);
        st.connect(serverID);
        st.createSharedObjects();
        System.out.println("Waiting 40000 ms...");
        Thread.sleep(40000L);
        st.removeSharedObjects();
        st.disconnect();
        System.out.println("Exiting.");
    }
}

