/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.BundleClassResolver;
import org.eclipse.ecf.core.util.ClassResolverObjectInputStream;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.IClassResolver;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.provider.generic.GenericContainerInstantiator;
import org.eclipse.ecf.provider.generic.SSLGenericContainerInstantiator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class ProviderPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider";
    private static final boolean genericClassResolverOverride = Boolean.valueOf(System.getProperty("org.eclipse.ecf.provider.classResolverOverride", "false"));
    private static ProviderPlugin plugin;
    public static final String NAMESPACE_IDENTIFIER;
    private BundleContext context = null;
    private ServiceTracker logServiceTracker = null;
    private AdapterManagerTracker adapterManagerTracker = null;
    private ServiceTracker sslServerSocketFactoryTracker;
    private ServiceTracker sslSocketFactoryTracker;
    private LogService systemLogService;

    static {
        NAMESPACE_IDENTIFIER = StringID.class.getName();
    }

    public IAdapterManager getAdapterManager() {
        if (this.context == null) {
            return null;
        }
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new AdapterManagerTracker(this.context);
            this.adapterManagerTracker.open();
        }
        return this.adapterManagerTracker.getAdapterManager();
    }

    public ProviderPlugin() {
        plugin = this;
    }

    public void start(final BundleContext context1) throws Exception {
        this.context = context1;
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(this.context){

            protected void runWithoutRegistry() throws Exception {
                context1.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.generic.server", (IContainerInstantiator)new GenericContainerInstantiator(), "ECF Generic Server", true, false), null);
                context1.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.generic.client", (IContainerInstantiator)new GenericContainerInstantiator(), "ECF Generic Client", true, true), null);
                context1.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.generic.ssl.server", (IContainerInstantiator)new SSLGenericContainerInstantiator(), "ECF SSL Generic Server", true, false), null);
                context1.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.generic.ssl.client", (IContainerInstantiator)new SSLGenericContainerInstantiator(), "ECF SSL Generic Client", true, true), null);
            }
        });
        if (genericClassResolverOverride) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("org.eclipse.ecf.core.util.classresolver.bundleSymbolicName", PLUGIN_ID);
            this.context.registerService(IClassResolver.class, (Object)new BundleClassResolver(this.context.getBundle()), props);
        }
    }

    public ObjectInputStream createObjectInputStream(InputStream ins) throws IOException {
        return genericClassResolverOverride ? ClassResolverObjectInputStream.create((BundleContext)this.context, (InputStream)ins) : new ObjectInputStream(ins);
    }

    public void stop(BundleContext context1) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.sslServerSocketFactoryTracker != null) {
            this.sslServerSocketFactoryTracker.close();
            this.sslServerSocketFactoryTracker = null;
        }
        if (this.sslSocketFactoryTracker != null) {
            this.sslSocketFactoryTracker.close();
            this.sslSocketFactoryTracker = null;
        }
        this.context = null;
    }

    protected LogService getLogService() {
        if (this.context == null) {
            if (this.systemLogService == null) {
                this.systemLogService = new SystemLogService(PLUGIN_ID);
            }
            return this.systemLogService;
        }
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public static synchronized ProviderPlugin getDefault() {
        if (plugin == null) {
            plugin = new ProviderPlugin();
        }
        return plugin;
    }

    public String getNamespaceIdentifier() {
        return NAMESPACE_IDENTIFIER;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        if (this.context == null) {
            return null;
        }
        if (this.sslServerSocketFactoryTracker == null) {
            this.sslServerSocketFactoryTracker = new ServiceTracker(this.context, SSLServerSocketFactory.class.getName(), null);
            this.sslServerSocketFactoryTracker.open();
        }
        return (SSLServerSocketFactory)this.sslServerSocketFactoryTracker.getService();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.context == null) {
            return null;
        }
        if (this.sslSocketFactoryTracker == null) {
            this.sslSocketFactoryTracker = new ServiceTracker(this.context, SSLSocketFactory.class.getName(), null);
            this.sslSocketFactoryTracker.open();
        }
        return (SSLSocketFactory)this.sslSocketFactoryTracker.getService();
    }
}

