/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import ch.ethz.iks.slp.Advertiser;
import ch.ethz.iks.slp.Locator;
import java.util.Hashtable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.provider.jslp.LocatorDecorator;
import org.eclipse.ecf.internal.provider.jslp.LocatorDecoratorImpl;
import org.eclipse.ecf.internal.provider.jslp.NullPatternAdvertiser;
import org.eclipse.ecf.internal.provider.jslp.NullPatternLocator;
import org.eclipse.ecf.provider.jslp.container.ContainerInstantiator;
import org.eclipse.ecf.provider.jslp.container.JSLPDiscoveryContainer;
import org.eclipse.ecf.provider.jslp.identity.JSLPNamespace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.jslp";
    private volatile BundleContext bundleContext;
    private volatile ServiceTracker<Locator, Locator> locatorSt;
    private volatile ServiceTracker<Advertiser, Advertiser> advertiserSt;
    private volatile ServiceRegistration<?> serviceRegistration;
    private static final boolean ENABLE_JSLP;
    private final DiscoveryServiceFactory serviceFactory = new DiscoveryServiceFactory();

    static {
        ENABLE_JSLP = Boolean.valueOf(System.getProperty("ch.ethz.iks.slp.enable", "false"));
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Activator() {
        plugin = this;
    }

    public Bundle getBundle() {
        return this.bundleContext.getBundle();
    }

    public LocatorDecorator getLocator() {
        this.locatorSt.open();
        Locator aLocator = (Locator)this.locatorSt.getService();
        if (aLocator == null) {
            return new NullPatternLocator();
        }
        return new LocatorDecoratorImpl(aLocator);
    }

    public Advertiser getAdvertiser() {
        this.advertiserSt.open();
        Advertiser advertiser = (Advertiser)this.advertiserSt.getService();
        if (advertiser == null) {
            return new NullPatternAdvertiser();
        }
        return advertiser;
    }

    public void start(final BundleContext context) throws Exception {
        if (ENABLE_JSLP) {
            this.bundleContext = context;
            SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(context){

                protected void runWithoutRegistry() throws Exception {
                    context.registerService(Namespace.class, (Object)new JSLPNamespace(), null);
                    context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.jslp", (IContainerInstantiator)new ContainerInstantiator(), "JSLP Discovery Container", true, false), null);
                    context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.jslp.locator", (IContainerInstantiator)new ContainerInstantiator(), "JSLP Discovery Locator Container", true, false), null);
                    context.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.discovery.jslp.advertiser", (IContainerInstantiator)new ContainerInstantiator(), "JSLP Discovery Advertiser Container", true, false), null);
                }
            });
            this.locatorSt = new ServiceTracker(context, Locator.class.getName(), null);
            this.advertiserSt = new ServiceTracker(context, Advertiser.class.getName(), null);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("org.eclipse.ecf.discovery.containerName", "ecf.discovery.jslp");
            props.put("service.ranking", 500);
            String[] clazzes = new String[]{IDiscoveryService.class.getName(), IDiscoveryLocator.class.getName(), IDiscoveryAdvertiser.class.getName()};
            this.serviceRegistration = context.registerService(clazzes, (Object)this.serviceFactory, props);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceRegistration != null && this.serviceFactory.isActive()) {
            ServiceReference reference = this.serviceRegistration.getReference();
            IDiscoveryLocator aLocator = (IDiscoveryLocator)context.getService(reference);
            this.serviceRegistration.unregister();
            IContainer container = (IContainer)aLocator.getAdapter(IContainer.class);
            container.disconnect();
            container.dispose();
            this.serviceRegistration = null;
        }
        plugin = null;
        this.bundleContext = null;
        if (this.advertiserSt != null) {
            this.advertiserSt.close();
            this.advertiserSt = null;
        }
        if (this.locatorSt != null) {
            this.locatorSt.close();
            this.locatorSt = null;
        }
    }

    class DiscoveryServiceFactory
    implements ServiceFactory {
        private volatile JSLPDiscoveryContainer jdc;

        DiscoveryServiceFactory() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            if (this.jdc == null) {
                try {
                    this.jdc = new JSLPDiscoveryContainer();
                    this.jdc.connect(null, null);
                }
                catch (ContainerConnectException e) {
                    Trace.catching((String)Activator.PLUGIN_ID, (String)"org.eclipse.ecf.provider.jslp/debug/methods/tracing", this.getClass(), (String)"getService(Bundle, ServiceRegistration)", (Throwable)e);
                    this.jdc = null;
                }
            }
            return this.jdc;
        }

        public boolean isActive() {
            return this.jdc != null;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

