/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.comm.tcp.ISocketAcceptHandler;
import org.eclipse.ecf.provider.generic.SOContainerGroup;

public class SSLServerSOContainerGroup
extends SOContainerGroup
implements ISocketAcceptHandler {
    public static final int DEFAULT_BACKLOG = 50;
    public static final String DEFAULT_GROUP_NAME = SSLServerSOContainerGroup.class.getName();
    private int port = 0;
    private int backlog = 50;
    SSLServerSocket serverSocket;
    private boolean isOnTheAir = false;
    private ThreadGroup threadGroup;
    private InetAddress inetAddress;
    private Thread listenerThread;

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port, int backlog, InetAddress inetAddress) {
        super(name);
        this.threadGroup = group;
        this.port = port;
        this.backlog = backlog;
        this.inetAddress = inetAddress;
        this.listenerThread = this.setupListener();
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port, int backlog) {
        this(name, group, port, backlog, null);
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port, InetAddress bindAddress) {
        this(name, group, port, 50, bindAddress);
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port) {
        this(name, group, port, 50);
    }

    public SSLServerSOContainerGroup(String name, int port) {
        this(name, null, port);
    }

    public SSLServerSOContainerGroup(int port) {
        this(DEFAULT_GROUP_NAME, null, port);
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, SSLServerSocket sslServerSocket) {
        super(name);
        this.threadGroup = group;
        this.serverSocket = sslServerSocket;
        this.port = this.serverSocket.getLocalPort();
        this.listenerThread = this.setupListener();
    }

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug", (String)msg);
    }

    protected void traceStack(String msg, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", SSLServerSOContainerGroup.class, (String)msg, (Throwable)e);
    }

    public synchronized void putOnTheAir() throws IOException {
        this.trace("SSLServerSOContainerGroup at port " + this.port + " on the air");
        if (this.serverSocket == null) {
            SSLServerSocketFactory socketFactory = ProviderPlugin.getDefault().getSSLServerSocketFactory();
            if (socketFactory == null) {
                throw new IOException("Cannot get SSLServerSocketFactory to create SSLServerSocket");
            }
            this.serverSocket = (SSLServerSocket)(this.inetAddress == null ? socketFactory.createServerSocket(this.port, this.backlog) : socketFactory.createServerSocket(this.port, this.backlog, this.inetAddress));
        }
        this.port = this.serverSocket.getLocalPort();
        this.isOnTheAir = true;
        this.listenerThread.start();
    }

    public synchronized boolean isOnTheAir() {
        return this.isOnTheAir;
    }

    public synchronized void takeOffTheAir() {
        this.trace("Taking " + this.getName() + " off the air.");
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
            this.listenerThread = null;
        }
        if (this.threadGroup != null) {
            this.threadGroup.interrupt();
            this.threadGroup = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/connection", SSLServerSOContainerGroup.class, (String)"takeOffTheAir", (Throwable)e);
            }
            this.serverSocket = null;
        }
        this.isOnTheAir = false;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + ";port:" + this.port;
    }

    protected Thread setupListener() {
        return new Thread(this.threadGroup, new Runnable(){

            public void run() {
                try {
                    while (true) {
                        SSLServerSOContainerGroup.this.handleAccept(SSLServerSOContainerGroup.this.serverSocket.accept());
                    }
                }
                catch (Exception e) {
                    SSLServerSOContainerGroup.this.traceStack("Exception in accept", e);
                    SSLServerSOContainerGroup.this.debug("SSLServerSOContaienrGroup closing listener normally.");
                    return;
                }
            }
        }, "SSLServerSOContainerGroup(" + this.port + ")");
    }

    protected void handleSyncAccept(Socket aSocket) throws Exception {
        super.handleAccept(aSocket);
    }

    public void handleAccept(final Socket aSocket) {
        new Thread(this.threadGroup, new Runnable(){

            public void run() {
                try {
                    SSLServerSOContainerGroup.this.debug("accept:" + aSocket.getInetAddress());
                    SSLServerSOContainerGroup.this.handleSyncAccept(aSocket);
                }
                catch (Exception e) {
                    SSLServerSOContainerGroup.this.traceStack("Unexpected exception in handleAccept...closing", e);
                    try {
                        aSocket.close();
                    }
                    catch (IOException e1) {
                        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4, "accept.close", (Throwable)e1));
                    }
                }
            }
        }).start();
    }

    protected void debug(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/connection", (String)msg);
    }
}

