/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.net.InetAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.provider.comm.tcp.Server;
import org.eclipse.ecf.provider.generic.SOContainerGroup;

public class TCPServerSOContainerGroup
extends SOContainerGroup {
    public static final String DEFAULT_GROUP_NAME = TCPServerSOContainerGroup.class.getName();
    private int port;
    private Server listener;
    private boolean isOnTheAir = false;
    private final ThreadGroup threadGroup;
    private int backlog = 50;
    private InetAddress bindAddress;

    public TCPServerSOContainerGroup(String name, ThreadGroup group, int port, int backlog, InetAddress bindAddress) {
        super(name);
        this.threadGroup = group;
        this.port = port;
        this.backlog = backlog;
        this.bindAddress = bindAddress;
    }

    public TCPServerSOContainerGroup(String name, ThreadGroup group, int port, InetAddress bindAddress) {
        this(name, group, port, 50, bindAddress);
    }

    public TCPServerSOContainerGroup(String name, ThreadGroup group, int port) {
        this(name, group, port, 50, null);
    }

    public TCPServerSOContainerGroup(String name, int port) {
        this(name, null, port);
    }

    public TCPServerSOContainerGroup(int port) {
        this(DEFAULT_GROUP_NAME, port);
    }

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug", (String)("TRACING " + msg));
    }

    protected void traceStack(String msg, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", TCPServerSOContainerGroup.class, (String)msg, (Throwable)e);
    }

    public synchronized void putOnTheAir() throws IOException {
        this.trace("TCPServerSOContainerGroup at port " + this.port + " on the air");
        this.listener = new Server(this.threadGroup, this.port, this.backlog, this.bindAddress, this);
        this.port = this.listener.getLocalPort();
        this.isOnTheAir = true;
    }

    public synchronized boolean isOnTheAir() {
        return this.isOnTheAir;
    }

    public synchronized void takeOffTheAir() {
        if (this.listener != null) {
            this.trace("Taking " + this.getName() + " off the air.");
            try {
                this.listener.close();
            }
            catch (IOException e) {
                this.traceStack("Exception in closeListener", e);
            }
            this.listener = null;
        }
        this.isOnTheAir = false;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ";port:" + this.port;
    }
}

