/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class IQ
extends Packet {
    private Type type = Type.GET;

    public IQ() {
    }

    public IQ(IQ iq) {
        super(iq);
        this.type = iq.getType();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type == null ? Type.GET : type;
    }

    public String toXML() {
        XMPPError error;
        StringBuilder buf = new StringBuilder();
        buf.append("<iq ");
        if (this.getPacketID() != null) {
            buf.append("id=\"" + this.getPacketID() + "\" ");
        }
        if (this.getTo() != null) {
            buf.append("to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\" ");
        }
        if (this.getFrom() != null) {
            buf.append("from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\" ");
        }
        if (this.type == null) {
            buf.append("type=\"get\">");
        } else {
            buf.append("type=\"").append(this.getType()).append("\">");
        }
        String queryXML = this.getChildElementXML();
        if (queryXML != null) {
            buf.append(queryXML);
        }
        if ((error = this.getError()) != null) {
            buf.append(error.toXML());
        }
        buf.append("</iq>");
        return buf.toString();
    }

    public abstract String getChildElementXML();

    public static IQ createResultIQ(IQ request) {
        if (request.getType() != Type.GET && request.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        IQ result = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        result.setType(Type.RESULT);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        return result;
    }

    public static IQ createErrorResponse(IQ request, XMPPError error) {
        if (request.getType() != Type.GET && request.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        IQ result = new IQ(){

            public String getChildElementXML() {
                return IQ.this.getChildElementXML();
            }
        };
        result.setType(Type.ERROR);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        result.setError(error);
        return result;
    }

    public static class Type {
        public static final Type GET = new Type("get");
        public static final Type SET = new Type("set");
        public static final Type RESULT = new Type("result");
        public static final Type ERROR = new Type("error");
        private String value;

        public static Type fromString(String type) {
            if (type == null) {
                return null;
            }
            type = type.toLowerCase();
            if (GET.toString().equals(type)) {
                return GET;
            }
            if (SET.toString().equals(type)) {
                return SET;
            }
            if (ERROR.toString().equals(type)) {
                return ERROR;
            }
            if (RESULT.toString().equals(type)) {
                return RESULT;
            }
            return null;
        }

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

