/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;

public class RecordReaper
extends TimerTask {
    private final JmDNSImpl jmDNSImpl;

    public RecordReaper(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JmDNSImpl jmDNSImpl = this.jmDNSImpl;
        synchronized (jmDNSImpl) {
            if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                return;
            }
            ArrayList<DNSEntry> list = new ArrayList<DNSEntry>();
            DNSCache dNSCache = this.jmDNSImpl.getCache();
            synchronized (dNSCache) {
                Iterator i = this.jmDNSImpl.getCache().iterator();
                while (i.hasNext()) {
                    DNSCache.CacheNode n = (DNSCache.CacheNode)i.next();
                    while (n != null) {
                        list.add(n.getValue());
                        n = n.next();
                    }
                }
            }
            long now = System.currentTimeMillis();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                DNSRecord c = (DNSRecord)i.next();
                if (!c.isExpired(now)) continue;
                this.jmDNSImpl.updateRecord(now, c);
                this.jmDNSImpl.getCache().remove(c);
            }
        }
    }
}

